/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.mcp.server.extensions.util;

import hudson.model.BooleanParameterDefinition;
import hudson.model.ChoiceParameterDefinition;
import hudson.model.FileParameterDefinition;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.PasswordParameterDefinition;
import hudson.model.RunParameterDefinition;
import hudson.model.StringParameterDefinition;
import hudson.model.TextParameterDefinition;
import java.lang.reflect.Method;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ParameterValueFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ParameterValueFactory.class);

    public static ParameterValue createParameterValue(ParameterDefinition param, Object inputValue) {
        try {
            if (param instanceof StringParameterDefinition) {
                return ParameterValueFactory.createStringParameterValue((StringParameterDefinition)param, inputValue);
            }
            if (param instanceof BooleanParameterDefinition) {
                return ParameterValueFactory.createBooleanParameterValue((BooleanParameterDefinition)param, inputValue);
            }
            if (param instanceof ChoiceParameterDefinition) {
                return ParameterValueFactory.createChoiceParameterValue((ChoiceParameterDefinition)param, inputValue);
            }
            if (param instanceof TextParameterDefinition) {
                return ParameterValueFactory.createTextParameterValue((TextParameterDefinition)param, inputValue);
            }
            if (param instanceof PasswordParameterDefinition) {
                return ParameterValueFactory.createPasswordParameterValue((PasswordParameterDefinition)param, inputValue);
            }
            if (param instanceof RunParameterDefinition) {
                return ParameterValueFactory.createRunParameterValue((RunParameterDefinition)param, inputValue);
            }
            if (param instanceof FileParameterDefinition) {
                return ParameterValueFactory.createFileParameterValue((FileParameterDefinition)param, inputValue);
            }
            return ParameterValueFactory.createPluginParameterValue(param, inputValue);
        }
        catch (Exception e) {
            log.warn("Failed to create parameter value for {}: {}", (Object)param.getClass().getSimpleName(), (Object)e.getMessage());
            return null;
        }
    }

    private static ParameterValue createStringParameterValue(StringParameterDefinition param, Object inputValue) {
        if (inputValue != null) {
            return param.createValue(String.valueOf(inputValue));
        }
        return param.getDefaultParameterValue();
    }

    private static ParameterValue createBooleanParameterValue(BooleanParameterDefinition param, Object inputValue) {
        if (inputValue != null) {
            boolean value = inputValue instanceof Boolean ? (Boolean)inputValue : (inputValue instanceof String ? Boolean.parseBoolean((String)inputValue) : Boolean.parseBoolean(String.valueOf(inputValue)));
            return param.createValue(String.valueOf(value));
        }
        return param.getDefaultParameterValue();
    }

    private static ParameterValue createChoiceParameterValue(ChoiceParameterDefinition param, Object inputValue) {
        if (inputValue != null) {
            String value = String.valueOf(inputValue);
            if (param.getChoices().contains(value)) {
                return param.createValue(value);
            }
            log.warn("Invalid choice '{}' for parameter '{}'. Valid choices: {}", new Object[]{value, param.getName(), param.getChoices()});
            return param.getDefaultParameterValue();
        }
        return param.getDefaultParameterValue();
    }

    private static ParameterValue createTextParameterValue(TextParameterDefinition param, Object inputValue) {
        if (inputValue != null) {
            return param.createValue(String.valueOf(inputValue));
        }
        return param.getDefaultParameterValue();
    }

    private static ParameterValue createPasswordParameterValue(PasswordParameterDefinition param, Object inputValue) {
        if (inputValue != null) {
            String value = String.valueOf(inputValue);
            return param.createValue(value);
        }
        return param.getDefaultParameterValue();
    }

    private static ParameterValue createRunParameterValue(RunParameterDefinition param, Object inputValue) {
        if (inputValue != null) {
            String value = String.valueOf(inputValue);
            return param.createValue(value);
        }
        return param.getDefaultParameterValue();
    }

    private static ParameterValue createFileParameterValue(FileParameterDefinition param, Object inputValue) {
        log.warn("File parameter '{}' is not supported via MCP. File parameters require file uploads.", (Object)param.getName());
        return null;
    }

    private static ParameterValue createPluginParameterValue(ParameterDefinition param, Object inputValue) {
        try {
            Method method7;
            if (inputValue != null) {
                try {
                    method7 = param.getClass().getMethod("createValue", Object.class);
                    if (method7 != null) {
                        return (ParameterValue)method7.invoke((Object)param, inputValue);
                    }
                }
                catch (NoSuchMethodException method2) {
                    // empty catch block
                }
                try {
                    method7 = param.getClass().getMethod("createValue", String.class);
                    if (method7 != null) {
                        return (ParameterValue)method7.invoke((Object)param, String.valueOf(inputValue));
                    }
                }
                catch (NoSuchMethodException method3) {
                    // empty catch block
                }
                if (inputValue instanceof Boolean) {
                    try {
                        method7 = param.getClass().getMethod("createValue", Boolean.TYPE);
                        if (method7 != null) {
                            return (ParameterValue)method7.invoke((Object)param, inputValue);
                        }
                    }
                    catch (NoSuchMethodException method4) {
                        // empty catch block
                    }
                }
                if (inputValue instanceof List) {
                    try {
                        method7 = param.getClass().getMethod("createValue", List.class);
                        if (method7 != null) {
                            return (ParameterValue)method7.invoke((Object)param, inputValue);
                        }
                    }
                    catch (NoSuchMethodException method5) {
                        // empty catch block
                    }
                }
                if (inputValue instanceof List) {
                    try {
                        List list = (List)inputValue;
                        String[] array = (String[])list.stream().map(String::valueOf).toArray(String[]::new);
                        Method method6 = param.getClass().getMethod("createValue", String[].class);
                        if (method6 != null) {
                            return (ParameterValue)method6.invoke((Object)param, new Object[]{array});
                        }
                    }
                    catch (NoSuchMethodException list) {
                        // empty catch block
                    }
                }
            }
            try {
                method7 = param.getClass().getMethod("getDefaultParameterValue", new Class[0]);
                if (method7 != null) {
                    return (ParameterValue)method7.invoke((Object)param, new Object[0]);
                }
            }
            catch (NoSuchMethodException method7) {
                // empty catch block
            }
            log.warn("Could not create parameter value for plugin parameter type: {}", (Object)param.getClass().getName());
            return null;
        }
        catch (Exception e) {
            log.warn("Failed to create plugin parameter value for {}: {}", (Object)param.getClass().getName(), (Object)e.getMessage());
            return null;
        }
    }
}

