/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.mcp.server.extensions;

import hudson.Extension;
import hudson.console.PlainTextConsoleOutputStream;
import hudson.model.Run;
import io.jenkins.plugins.mcp.server.McpServerExtension;
import io.jenkins.plugins.mcp.server.annotation.Tool;
import io.jenkins.plugins.mcp.server.annotation.ToolParam;
import io.jenkins.plugins.mcp.server.extensions.util.JenkinsUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import jenkins.util.SystemProperties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class BuildLogsExtension
implements McpServerExtension {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BuildLogsExtension.class);

    @Tool(description="Retrieves some log lines with pagination for a specific build or the last build of a Jenkins job, as well as a boolean value indicating whether there is more content to retrieve", annotations=@Tool.Annotations(destructiveHint=false))
    public BuildLogResponse getBuildLog(@ToolParam(description="Job full name of the Jenkins job (e.g., 'folder/job-name')") String jobFullName, @ToolParam(description="The build number (optional, if not provided, returns the last build)", required=false) Integer buildNumber, @ToolParam(description="The skip (optional, if not provided, returns from the first line). Negative values function as 'from the end', with -1 meaning starting with the last line", required=false) Long skip, @ToolParam(description="The number of lines to return (optional, if not provided, returns 100 lines), positive values return lines from the start, negative values return lines from the end", required=false) Integer limit) {
        if (limit == null || limit == 0) {
            limit = 100;
        }
        if (skip == null) {
            skip = 0L;
        }
        int limitF = limit;
        long skipF = skip;
        return JenkinsUtil.getBuildByNumberOrLast(jobFullName, buildNumber).map(build -> {
            try {
                return this.getLogLines((Run<?, ?>)build, skipF, limitF);
            }
            catch (Exception e) {
                log.error("Error reading log for job {} build {}", new Object[]{jobFullName, buildNumber, e});
                return null;
            }
        }).orElse(null);
    }

    private BuildLogResponse getLogLines(Run<?, ?> run, long skip, int limit) throws Exception {
        int linesNumber;
        PlainTextConsoleOutputStream out;
        boolean negativeLimit;
        log.trace("getLogLines for run {}/{} called with skip {}, limit {}", new Object[]{run.getParent().getName(), run.getDisplayName(), skip, limit});
        int maxLimit = SystemProperties.getInteger((String)(BuildLogsExtension.class.getName() + ".limit.max"), (Integer)10000);
        boolean bl = negativeLimit = limit < 0;
        if (Math.abs(limit) > maxLimit) {
            log.warn("Limit {} is too large, using the default max limit {}", (Object)limit, (Object)maxLimit);
        }
        limit = Math.min(Math.abs(limit), maxLimit);
        if (negativeLimit) {
            limit = -limit;
        }
        long skipInit = skip;
        int limitInit = limit;
        long start = System.currentTimeMillis();
        log.trace("counting lines for run {}", (Object)run.getDisplayName());
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            out = new LinesNumberOutputStream(os);
            try {
                run.writeWholeLogTo((OutputStream)out);
                linesNumber = out.lines;
                if (log.isDebugEnabled()) {
                    log.debug("counted {} lines in {} ms", (Object)linesNumber, (Object)(System.currentTimeMillis() - start));
                }
            }
            finally {
                out.close();
            }
        }
        if (skip > 0L && limit < 0) {
            skip = Math.max(0L, skip - (long)Math.abs(limit));
            limit = Math.abs(limit);
        } else if (skip < 0L && limit > 0) {
            skip = Math.max(0L, (long)linesNumber + skip);
        } else if (skip < 0L && limit < 0) {
            skip = Math.max(0L, (long)linesNumber + skip - (long)Math.abs(limit));
            limit = Math.abs(limit);
        }
        start = System.currentTimeMillis();
        os = new ByteArrayOutputStream();
        try {
            BuildLogResponse buildLogResponse;
            out = new SkipLogOutputStream(os, skip, limit);
            try {
                run.writeWholeLogTo((OutputStream)out);
                if (log.isDebugEnabled()) {
                    log.debug("call with skip {}, limit {} for linesNumber {} with read with skip {}, limit {}, time to extract: {} ms", new Object[]{skipInit, limitInit, linesNumber, skip, limit, System.currentTimeMillis() - start});
                }
                buildLogResponse = new BuildLogResponse(out.hasMoreContent, os.toString(StandardCharsets.UTF_8).lines().toList());
            }
            catch (Throwable throwable) {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            out.close();
            return buildLogResponse;
        }
        finally {
            os.close();
        }
    }

    public record BuildLogResponse(boolean hasMoreContent, List<String> lines) {
    }

    private static class LinesNumberOutputStream
    extends PlainTextConsoleOutputStream {
        private int lines;

        public LinesNumberOutputStream(OutputStream out) throws IOException {
            super(out);
        }

        protected void eol(byte[] in, int sz) throws IOException {
            ++this.lines;
        }
    }

    private static class SkipLogOutputStream
    extends PlainTextConsoleOutputStream {
        private final long skip;
        private final int limit;
        private long current;
        private boolean hasMoreContent;

        public SkipLogOutputStream(OutputStream out, long skip, int limit) throws IOException {
            super(out);
            this.skip = skip;
            this.limit = limit;
        }

        protected void eol(byte[] in, int sz) throws IOException {
            if (this.current >= this.skip && (long)this.limit > this.current - this.skip) {
                super.eol(in, sz);
            } else if (this.current - this.skip >= (long)this.limit) {
                this.hasMoreContent = true;
            }
            ++this.current;
        }
    }

    private static class LimitedQueue<E> {
        private final int maxSize;
        private final Deque<E> deque;

        public LimitedQueue(int maxSize) {
            this.maxSize = maxSize;
            this.deque = new ArrayDeque(maxSize);
        }

        public boolean add(E e) {
            boolean removed = false;
            if (this.deque.size() == this.maxSize) {
                removed = true;
                this.deque.removeFirst();
            }
            this.deque.addLast(e);
            return removed;
        }

        public E remove() {
            return this.deque.removeFirst();
        }

        public int size() {
            return this.deque.size();
        }

        public boolean isEmpty() {
            return this.deque.isEmpty();
        }

        public String toString() {
            return this.deque.toString();
        }
    }
}

