/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.mcp.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.RootAction;
import hudson.model.User;
import hudson.security.csrf.CrumbExclusion;
import hudson.util.PluginServletFilter;
import io.jenkins.plugins.mcp.server.McpServerExtension;
import io.jenkins.plugins.mcp.server.annotation.Tool;
import io.jenkins.plugins.mcp.server.tool.McpToolWrapper;
import io.modelcontextprotocol.common.McpTransportContext;
import io.modelcontextprotocol.json.McpJsonMapper;
import io.modelcontextprotocol.json.jackson.JacksonMcpJsonMapper;
import io.modelcontextprotocol.json.schema.JsonSchemaValidator;
import io.modelcontextprotocol.json.schema.jackson.DefaultJsonSchemaValidator;
import io.modelcontextprotocol.server.McpServer;
import io.modelcontextprotocol.server.McpTransportContextExtractor;
import io.modelcontextprotocol.server.transport.HttpServletSseServerTransportProvider;
import io.modelcontextprotocol.server.transport.HttpServletStreamableServerTransportProvider;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.spec.McpServerTransportProvider;
import io.modelcontextprotocol.spec.McpStreamableServerTransportProvider;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import jenkins.model.JenkinsLocationConfiguration;
import jenkins.util.SystemProperties;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Restricted(value={NoExternalUse.class})
@Extension
public class Endpoint
extends CrumbExclusion
implements RootAction {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Endpoint.class);
    public static final String MCP_SERVER = "mcp-server";
    public static final String SSE_ENDPOINT = "/sse";
    public static final String MCP_SERVER_SSE = "mcp-server/sse";
    public static final String STREAMABLE_ENDPOINT = "/mcp";
    public static final String MCP_SERVER_STREAMABLE = "mcp-server/mcp";
    private static final String MESSAGE_ENDPOINT = "/message";
    public static final String MCP_SERVER_MESSAGE = "mcp-server/message";
    public static final String USER_ID = Endpoint.class.getName() + ".userId";
    private static final String MCP_CONTEXT_KEY = Endpoint.class.getName() + ".mcpContext";
    private static int keepAliveInterval = SystemProperties.getInteger((String)(Endpoint.class.getName() + ".keepAliveInterval"), (Integer)0);
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="Accessible via System Groovy Scripts")
    public static boolean REQUIRE_ORIGIN_HEADER = SystemProperties.getBoolean((String)(Endpoint.class.getName() + ".requireOriginHeader"), (boolean)false);
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="Accessible via System Groovy Scripts")
    public static boolean REQUIRE_ORIGIN_MATCH = SystemProperties.getBoolean((String)(Endpoint.class.getName() + ".requireOriginMatch"), (boolean)true);
    private final ObjectMapper objectMapper = new ObjectMapper();
    HttpServletSseServerTransportProvider httpServletSseServerTransportProvider;
    HttpServletStreamableServerTransportProvider httpServletStreamableServerTransportProvider;

    public Endpoint() throws ServletException {
        this.init();
    }

    public static String getRequestedResourcePath(HttpServletRequest httpServletRequest) {
        return httpServletRequest.getRequestURI().substring(httpServletRequest.getContextPath().length());
    }

    public boolean process(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!this.validateOriginHeader((ServletRequest)request, (ServletResponse)response)) {
            return true;
        }
        String requestedResource = Endpoint.getRequestedResourcePath(request);
        if (requestedResource.startsWith("/mcp-server/message") && request.getMethod().equalsIgnoreCase("POST")) {
            this.handleMessage((ServletRequest)request, (ServletResponse)response, (HttpServlet)this.httpServletSseServerTransportProvider);
            return true;
        }
        if (requestedResource.startsWith("/mcp-server/sse") && request.getMethod().equalsIgnoreCase("POST")) {
            response.sendError(405);
            return true;
        }
        if (this.isStreamableRequest((ServletRequest)request)) {
            this.handleMessage((ServletRequest)request, (ServletResponse)response, (HttpServlet)this.httpServletStreamableServerTransportProvider);
            return true;
        }
        return false;
    }

    protected void init() throws ServletException {
        McpSchema.ServerCapabilities serverCapabilities = McpSchema.ServerCapabilities.builder().tools(Boolean.valueOf(true)).prompts(Boolean.valueOf(true)).resources(Boolean.valueOf(true), Boolean.valueOf(true)).build();
        ExtensionList<McpServerExtension> extensions = McpServerExtension.all();
        List tools = extensions.stream().map(McpServerExtension::getSyncTools).flatMap(Collection::stream).toList();
        List prompts = extensions.stream().map(McpServerExtension::getSyncPrompts).flatMap(Collection::stream).toList();
        List resources = extensions.stream().map(McpServerExtension::getSyncResources).flatMap(Collection::stream).toList();
        List annotationTools = extensions.stream().flatMap(extension -> Arrays.stream(extension.getClass().getMethods()).filter(method -> method.isAnnotationPresent(Tool.class)).map(method -> new McpToolWrapper(this.objectMapper, extension, (Method)method).asSyncToolSpecification())).toList();
        ArrayList allTools = new ArrayList();
        allTools.addAll(tools);
        allTools.addAll(annotationTools);
        String rootUrl = JenkinsLocationConfiguration.get().getUrl();
        if (rootUrl == null) {
            rootUrl = "";
        }
        this.httpServletSseServerTransportProvider = HttpServletSseServerTransportProvider.builder().jsonMapper((McpJsonMapper)new JacksonMcpJsonMapper(this.objectMapper)).baseUrl(rootUrl).sseEndpoint(SSE_ENDPOINT).messageEndpoint(MCP_SERVER_MESSAGE).contextExtractor(Endpoint.createExtractor()).keepAliveInterval(keepAliveInterval > 0 ? Duration.ofSeconds(keepAliveInterval) : null).build();
        McpServer.sync((McpServerTransportProvider)this.httpServletSseServerTransportProvider).jsonMapper((McpJsonMapper)new JacksonMcpJsonMapper(this.objectMapper)).jsonSchemaValidator((JsonSchemaValidator)new DefaultJsonSchemaValidator(this.objectMapper)).capabilities(serverCapabilities).tools(allTools).prompts(prompts).resources(resources).build();
        this.httpServletStreamableServerTransportProvider = HttpServletStreamableServerTransportProvider.builder().jsonMapper((McpJsonMapper)new JacksonMcpJsonMapper(this.objectMapper)).mcpEndpoint(STREAMABLE_ENDPOINT).contextExtractor(Endpoint.createExtractor()).keepAliveInterval(keepAliveInterval > 0 ? Duration.ofSeconds(keepAliveInterval) : null).build();
        McpServer.sync((McpStreamableServerTransportProvider)this.httpServletStreamableServerTransportProvider).jsonMapper((McpJsonMapper)new JacksonMcpJsonMapper(this.objectMapper)).jsonSchemaValidator((JsonSchemaValidator)new DefaultJsonSchemaValidator(this.objectMapper)).capabilities(serverCapabilities).tools(allTools).prompts(prompts).resources(resources).build();
        PluginServletFilter.addFilter((servletRequest, servletResponse, filterChain) -> {
            boolean continueRequest = this.validateOriginHeader(servletRequest, servletResponse);
            if (!continueRequest) {
                return;
            }
            if (this.isSSERequest(servletRequest)) {
                this.handleSSE(servletRequest, servletResponse);
            } else if (this.isStreamableRequest(servletRequest)) {
                this.handleMessage(servletRequest, servletResponse, (HttpServlet)this.httpServletStreamableServerTransportProvider);
            } else {
                filterChain.doFilter(servletRequest, servletResponse);
            }
        });
    }

    private static McpTransportContextExtractor<HttpServletRequest> createExtractor() {
        return httpServletRequest -> (McpTransportContext)httpServletRequest.getAttribute(MCP_CONTEXT_KEY);
    }

    private boolean validateOriginHeader(ServletRequest request, ServletResponse response) {
        String originHeaderValue = ((HttpServletRequest)request).getHeader("Origin");
        if (REQUIRE_ORIGIN_HEADER && StringUtils.isEmpty((CharSequence)originHeaderValue)) {
            try {
                ((HttpServletResponse)response).sendError(403, "Missing Origin header");
                return false;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (REQUIRE_ORIGIN_MATCH && !StringUtils.isEmpty((CharSequence)originHeaderValue)) {
            String expectedOrigin;
            String removeSuffix2;
            String removeSuffix1;
            String jenkinsRootUrl = JenkinsLocationConfiguration.get().getUrl();
            if (StringUtils.isEmpty((CharSequence)jenkinsRootUrl)) {
                return true;
            }
            String o = this.getRootUrlFromRequest((HttpServletRequest)request);
            if (o.endsWith(removeSuffix1 = "/")) {
                o = o.substring(0, o.length() - removeSuffix1.length());
            }
            if (o.endsWith(removeSuffix2 = ((HttpServletRequest)request).getContextPath())) {
                o = o.substring(0, o.length() - removeSuffix2.length());
            }
            if (!originHeaderValue.equals(expectedOrigin = o)) {
                log.debug("Rejecting origin: {}; expected was from request: {}", (Object)originHeaderValue, (Object)expectedOrigin);
                try {
                    ((HttpServletResponse)response).sendError(403, "Unexpected request origin (check your reverse proxy settings)");
                    return false;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return true;
    }

    @NonNull
    private String getRootUrlFromRequest(HttpServletRequest req) {
        StringBuilder buf = new StringBuilder();
        String scheme = Endpoint.getXForwardedHeader(req, "X-Forwarded-Proto", req.getScheme());
        buf.append(scheme).append("://");
        String host = Endpoint.getXForwardedHeader(req, "X-Forwarded-Host", req.getServerName());
        int index = host.lastIndexOf(58);
        int port = req.getServerPort();
        if (index == -1) {
            buf.append(host);
        } else if (host.startsWith("[") && host.endsWith("]")) {
            buf.append(host);
        } else {
            buf.append(host, 0, index);
            if (index + 1 < host.length()) {
                try {
                    port = Integer.parseInt(host.substring(index + 1));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        String forwardedPort = Endpoint.getXForwardedHeader(req, "X-Forwarded-Port", null);
        if (forwardedPort != null) {
            try {
                port = Integer.parseInt(forwardedPort);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (port != ("https".equals(scheme) ? 443 : 80)) {
            buf.append(':').append(port);
        }
        buf.append(req.getContextPath()).append('/');
        return buf.toString();
    }

    private static String getXForwardedHeader(HttpServletRequest req, String header, String defaultValue) {
        String value = req.getHeader(header);
        if (value != null) {
            int index = value.indexOf(44);
            return index == -1 ? value.trim() : value.substring(0, index).trim();
        }
        return defaultValue;
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return MCP_SERVER;
    }

    boolean isSSERequest(ServletRequest servletRequest) {
        if (servletRequest instanceof HttpServletRequest) {
            HttpServletRequest request = (HttpServletRequest)servletRequest;
            String requestedResource = Endpoint.getRequestedResourcePath(request);
            return requestedResource.startsWith("/mcp-server/sse") && request.getMethod().equalsIgnoreCase("GET");
        }
        return false;
    }

    boolean isStreamableRequest(ServletRequest servletRequest) {
        if (servletRequest instanceof HttpServletRequest) {
            HttpServletRequest request = (HttpServletRequest)servletRequest;
            String requestedResource = Endpoint.getRequestedResourcePath(request);
            return requestedResource.startsWith("/mcp-server/mcp") && (request.getMethod().equalsIgnoreCase("GET") || request.getMethod().equalsIgnoreCase("POST"));
        }
        return false;
    }

    protected void handleSSE(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        this.httpServletSseServerTransportProvider.service(request, response);
    }

    private void handleMessage(ServletRequest request, ServletResponse response, HttpServlet httpServlet) throws IOException, ServletException {
        Endpoint.prepareMcpContext(request);
        httpServlet.service(request, response);
    }

    private static void prepareMcpContext(ServletRequest request) {
        HashMap<String, String> contextMap = new HashMap<String, String>();
        User currentUser = User.current();
        String userId = null;
        if (currentUser != null) {
            userId = currentUser.getId();
        }
        if (userId != null) {
            contextMap.put(USER_ID, userId);
        }
        request.setAttribute(MCP_CONTEXT_KEY, (Object)McpTransportContext.create(contextMap));
    }
}

