/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.mcp.server.tool;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.victools.jsonschema.generator.Option;
import com.github.victools.jsonschema.generator.OptionPreset;
import com.github.victools.jsonschema.generator.SchemaGenerator;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfig;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.SchemaVersion;
import com.github.victools.jsonschema.module.jackson.JacksonModule;
import com.github.victools.jsonschema.module.jackson.JacksonOption;
import com.github.victools.jsonschema.module.swagger2.Swagger2Module;
import hudson.model.User;
import hudson.security.ACL;
import io.jenkins.plugins.mcp.server.Endpoint;
import io.jenkins.plugins.mcp.server.annotation.Tool;
import io.jenkins.plugins.mcp.server.annotation.ToolParam;
import io.jenkins.plugins.mcp.server.jackson.JenkinsExportedBeanModule;
import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.server.McpSyncServerExchange;
import io.modelcontextprotocol.server.McpTransportContext;
import io.modelcontextprotocol.spec.McpSchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class McpToolWrapper {
    private static final SchemaGenerator TYPE_SCHEMA_GENERATOR;
    private static final SchemaGenerator SUBTYPE_SCHEMA_GENERATOR;
    private static final boolean PROPERTY_REQUIRED_BY_DEFAULT = true;
    private static final ObjectMapper OBJECT_MAPPER;
    private final Method method;
    private final Object target;
    private final ObjectMapper objectMapper;

    public McpToolWrapper(ObjectMapper objectMapper, Object target, Method method) {
        this.objectMapper = objectMapper;
        this.target = target;
        this.method = method;
    }

    private static boolean isMethodParameterRequired(Method method, int index) {
        Parameter parameter = method.getParameters()[index];
        JsonProperty propertyAnnotation = parameter.getAnnotation(JsonProperty.class);
        if (propertyAnnotation != null) {
            return propertyAnnotation.required();
        }
        Schema schemaAnnotation = parameter.getAnnotation(Schema.class);
        if (schemaAnnotation != null) {
            return schemaAnnotation.requiredMode() == Schema.RequiredMode.REQUIRED || schemaAnnotation.requiredMode() == Schema.RequiredMode.AUTO || schemaAnnotation.required();
        }
        org.springframework.lang.Nullable nullableAnnotation = parameter.getAnnotation(org.springframework.lang.Nullable.class);
        if (nullableAnnotation != null) {
            return false;
        }
        Nullable jakartaNullableAnnotation = parameter.getAnnotation(Nullable.class);
        if (jakartaNullableAnnotation != null) {
            return false;
        }
        ToolParam toolParamAnnotation = parameter.getAnnotation(ToolParam.class);
        if (toolParamAnnotation != null) {
            return toolParamAnnotation.required();
        }
        return true;
    }

    @org.springframework.lang.Nullable
    private static String getMethodParameterDescription(Method method, int index) {
        Parameter parameter = method.getParameters()[index];
        ToolParam toolParamAnnotation = parameter.getAnnotation(ToolParam.class);
        if (toolParamAnnotation != null && StringUtils.hasText((String)toolParamAnnotation.description())) {
            return toolParamAnnotation.description();
        }
        JsonPropertyDescription jacksonAnnotation = parameter.getAnnotation(JsonPropertyDescription.class);
        if (jacksonAnnotation != null && StringUtils.hasText((String)jacksonAnnotation.value())) {
            return jacksonAnnotation.value();
        }
        Schema schemaAnnotation = parameter.getAnnotation(Schema.class);
        if (schemaAnnotation != null && StringUtils.hasText((String)schemaAnnotation.description())) {
            return schemaAnnotation.description();
        }
        return null;
    }

    private static String toJson(Object item) throws IOException {
        return OBJECT_MAPPER.writeValueAsString(item);
    }

    String generateForMethodInput() {
        ObjectNode schema = this.objectMapper.createObjectNode();
        schema.put("$schema", SchemaVersion.DRAFT_2020_12.getIdentifier());
        schema.put("type", "object");
        ObjectNode properties = schema.putObject("properties");
        ArrayList<String> required = new ArrayList<String>();
        for (int i = 0; i < this.method.getParameterCount(); ++i) {
            String parameterName = this.method.getParameters()[i].getName();
            Type parameterType = this.method.getGenericParameterTypes()[i];
            if (McpToolWrapper.isMethodParameterRequired(this.method, i)) {
                required.add(parameterName);
            }
            ObjectNode parameterNode = SUBTYPE_SCHEMA_GENERATOR.generateSchema(parameterType, new Type[0]);
            String parameterDescription = McpToolWrapper.getMethodParameterDescription(this.method, i);
            if (StringUtils.hasText((String)parameterDescription)) {
                parameterNode.put("description", parameterDescription);
            }
            properties.set(parameterName, (JsonNode)parameterNode);
        }
        ArrayNode requiredArray = schema.putArray("required");
        required.forEach(arg_0 -> ((ArrayNode)requiredArray).add(arg_0));
        return schema.toPrettyString();
    }

    String getToolName() {
        Assert.notNull((Object)this.method, (String)"method cannot be null");
        Tool tool = this.method.getAnnotation(Tool.class);
        if (tool == null) {
            return this.method.getName();
        }
        return StringUtils.hasText((String)tool.name()) ? tool.name() : this.method.getName();
    }

    String getToolDescription() {
        Assert.notNull((Object)this.method, (String)"method cannot be null");
        Tool tool = this.method.getAnnotation(Tool.class);
        if (tool != null && !tool.description().isEmpty()) {
            return tool.description();
        }
        return this.getToolName();
    }

    McpSchema.CallToolResult toMcpResult(Object result) {
        if (result == null) {
            return McpSchema.CallToolResult.builder().addTextContent("Result is null").isError(Boolean.valueOf(false)).build();
        }
        try {
            McpSchema.CallToolResult.Builder resultBuilder = McpSchema.CallToolResult.builder().isError(Boolean.valueOf(false));
            if (result instanceof List) {
                List listResult = (List)result;
                for (Object item : listResult) {
                    resultBuilder.addTextContent(McpToolWrapper.toJson(item));
                }
            } else {
                resultBuilder.addTextContent(McpToolWrapper.toJson(result));
            }
            return resultBuilder.build();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    McpSchema.CallToolResult callRequest(McpSyncServerExchange exchange, McpSchema.CallToolRequest request) {
        Map args = request.arguments();
        User oldUser = User.current();
        try {
            User user = McpToolWrapper.tryGetUser(exchange, request);
            if (user != null) {
                ACL.as((User)user);
            }
            Object[] methodArgs = Arrays.stream(this.method.getParameters()).map(param -> {
                Object arg = args.get(param.getName());
                if (arg != null) {
                    return this.objectMapper.convertValue(arg, param.getType());
                }
                return null;
            }).toArray();
            Object result = this.method.invoke(this.target, methodArgs);
            McpSchema.CallToolResult callToolResult = this.toMcpResult(result);
            return callToolResult;
        }
        catch (Exception e) {
            Object rootCauseMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
            if (((String)rootCauseMessage).isEmpty()) {
                rootCauseMessage = "Error invoking method: " + this.method.getName();
            }
            McpSchema.CallToolResult callToolResult = McpSchema.CallToolResult.builder().isError(Boolean.valueOf(true)).addTextContent((String)rootCauseMessage).build();
            return callToolResult;
        }
        finally {
            ACL.as((User)oldUser);
        }
    }

    private static User tryGetUser(McpSyncServerExchange exchange, McpSchema.CallToolRequest request) {
        String userId = null;
        McpTransportContext context = exchange.transportContext();
        if (context != null) {
            userId = (String)context.get(Endpoint.USER_ID);
        }
        if (userId == null && request.meta() != null) {
            userId = (String)request.meta().get(Endpoint.USER_ID);
        }
        User user = User.get((String)userId, (boolean)false, Map.of());
        return user;
    }

    public McpServerFeatures.SyncToolSpecification asSyncToolSpecification() {
        return McpServerFeatures.SyncToolSpecification.builder().tool(McpSchema.Tool.builder().name(this.getToolName()).description(this.getToolDescription()).inputSchema(this.generateForMethodInput()).build()).callHandler(this::callRequest).build();
    }

    static {
        OBJECT_MAPPER = new ObjectMapper();
        OBJECT_MAPPER.registerModule((Module)new JenkinsExportedBeanModule());
        JacksonModule jacksonModule = new JacksonModule(new JacksonOption[]{JacksonOption.RESPECT_JSONPROPERTY_REQUIRED});
        Swagger2Module openApiModule = new Swagger2Module();
        SchemaGeneratorConfigBuilder schemaGeneratorConfigBuilder = new SchemaGeneratorConfigBuilder(SchemaVersion.DRAFT_2020_12, OptionPreset.PLAIN_JSON).with((com.github.victools.jsonschema.generator.Module)jacksonModule).with((com.github.victools.jsonschema.generator.Module)openApiModule).with(Option.EXTRA_OPEN_API_FORMAT_VALUES, new Option[0]).with(Option.PLAIN_DEFINITION_KEYS, new Option[0]);
        SchemaGeneratorConfig typeSchemaGeneratorConfig = schemaGeneratorConfigBuilder.build();
        TYPE_SCHEMA_GENERATOR = new SchemaGenerator(typeSchemaGeneratorConfig);
        SchemaGeneratorConfig subtypeSchemaGeneratorConfig = schemaGeneratorConfigBuilder.without(Option.SCHEMA_VERSION_INDICATOR, new Option[0]).build();
        SUBTYPE_SCHEMA_GENERATOR = new SchemaGenerator(subtypeSchemaGeneratorConfig);
    }
}

