/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.mcp.server.extensions;

import hudson.Extension;
import io.jenkins.plugins.mcp.server.McpServerExtension;
import io.jenkins.plugins.mcp.server.annotation.Tool;
import io.jenkins.plugins.mcp.server.annotation.ToolParam;
import io.jenkins.plugins.mcp.server.extensions.util.JenkinsUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class BuildLogsExtension
implements McpServerExtension {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BuildLogsExtension.class);

    @Tool(description="Retrieves some log lines with pagination for a specific build or the last build of a Jenkins job, as well as a boolean value indicating whether there is more content to retrieve")
    public BuildLogResponse getBuildLog(@ToolParam(description="Job full name of the Jenkins job (e.g., 'folder/job-name')") String jobFullName, @ToolParam(description="The build number (optional, if not provided, returns the last build)", required=false) Integer buildNumber, @ToolParam(description="The skip (optional, if not provided, returns the first line). Negative values function as 'from the end', with -1 meaning starting with the last line", required=false) Long skip, @ToolParam(description="The number of lines to return (optional, if not provided, returns 100 lines)", required=false) Integer limit) {
        if (limit == null || limit == 0) {
            limit = 100;
        }
        if (skip == null) {
            skip = 0L;
        }
        int limitF = limit;
        long skipF = skip;
        return JenkinsUtil.getBuildByNumberOrLast(jobFullName, buildNumber).map(build -> {
            BuildLogResponse buildLogResponse;
            BufferedReader reader = new BufferedReader(build.getLogReader());
            try {
                List<String> allLines = reader.lines().toList();
                long actualOffset = skipF;
                if (skipF < 0L) {
                    actualOffset = Math.max(0L, (long)allLines.size() + skipF);
                }
                int endIndex = (int)Math.min(actualOffset + (long)limitF, (long)allLines.size());
                List<String> lines = allLines.subList((int)actualOffset, endIndex);
                boolean hasMoreContent = endIndex < allLines.size();
                buildLogResponse = new BuildLogResponse(hasMoreContent, lines);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    log.error("Error reading log for job {} build {}", new Object[]{jobFullName, buildNumber, e});
                    return null;
                }
            }
            reader.close();
            return buildLogResponse;
        }).orElse(null);
    }

    public record BuildLogResponse(boolean hasMoreContent, List<String> lines) {
    }
}

