/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.mcp.server.extensions;

import hudson.Extension;
import hudson.model.AbstractItem;
import hudson.model.Action;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Run;
import hudson.model.SimpleParameterDefinition;
import hudson.model.User;
import io.jenkins.plugins.mcp.server.McpServerExtension;
import io.jenkins.plugins.mcp.server.annotation.Tool;
import io.jenkins.plugins.mcp.server.annotation.ToolParam;
import io.jenkins.plugins.mcp.server.extensions.util.JenkinsUtil;
import jakarta.annotation.Nullable;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class DefaultMcpServer
implements McpServerExtension {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultMcpServer.class);
    public static final String FULL_NAME = "fullName";

    @Tool(description="Get a specific build or the last build of a Jenkins job")
    public Run getBuild(@ToolParam(description="Job full name of the Jenkins job (e.g., 'folder/job-name')") String jobFullName, @Nullable @ToolParam(description="Build number (optional, if not provided, returns the last build)", required=false) Integer buildNumber) {
        return JenkinsUtil.getBuildByNumberOrLast(jobFullName, buildNumber).orElse(null);
    }

    @Tool(description="Get a Jenkins job by its full path")
    public Job getJob(@ToolParam(description="Job full name of the Jenkins job (e.g., 'folder/job-name')") String jobFullName) {
        return (Job)Jenkins.get().getItemByFullName(jobFullName, Job.class);
    }

    @Tool(description="Trigger a build for a Jenkins job")
    public boolean triggerBuild(@ToolParam(description="Full path of the Jenkins job (e.g., 'folder/job-name')") String jobFullName, @ToolParam(description="Build parameters (optional, e.g., {key1=value1,key2=value2})", required=false) Map<String, Object> parameters) {
        ParameterizedJobMixIn.ParameterizedJob job = (ParameterizedJobMixIn.ParameterizedJob)Jenkins.get().getItemByFullName(jobFullName, ParameterizedJobMixIn.ParameterizedJob.class);
        if (job != null) {
            if (job.isParameterized() && job instanceof Job) {
                Job j = (Job)job;
                ParametersDefinitionProperty parametersDefinition = (ParametersDefinitionProperty)j.getProperty(ParametersDefinitionProperty.class);
                List<ParameterValue> parameterValues = parametersDefinition.getParameterDefinitions().stream().map(param -> {
                    if (param instanceof SimpleParameterDefinition) {
                        SimpleParameterDefinition sd = (SimpleParameterDefinition)param;
                        if (parameters != null && parameters.containsKey(param.getName())) {
                            Object value = parameters.get(param.getName());
                            return sd.createValue(String.valueOf(value));
                        }
                        return sd.getDefaultParameterValue();
                    }
                    log.warn("Unsupported parameter type: {}", (Object)param.getClass().getName());
                    return null;
                }).filter(Objects::nonNull).toList();
                job.scheduleBuild2(0, new Action[]{new ParametersAction(parameterValues)});
            } else {
                job.scheduleBuild2(0, new Action[0]);
            }
            return true;
        }
        return false;
    }

    @Tool(description="Get a paginated list of Jenkins jobs, sorted by name. Returns up to 'limit' jobs starting from the 'skip' index. If no jobs are available in the requested range, returns an empty list.")
    public List<Job> getJobs(@ToolParam(description="The full path of the Jenkins folder (e.g., 'folder'), if not specified, it returns the items under root", required=false) String parentFullName, @ToolParam(description="The 0 based started index, if not specified, then start from the first (0)", required=false) Integer skip, @ToolParam(description="The maximum number of items to return. If not specified, returns 10 items. Cannot exceed 10 items.", required=false) Integer limit) {
        if (skip == null || skip < 0) {
            skip = 0;
        }
        if (limit == null || limit < 0 || limit > 10) {
            limit = 10;
        }
        Jenkins parent = null;
        if (parentFullName == null || parentFullName.isEmpty()) {
            parent = Jenkins.get();
        } else {
            AbstractItem fullNameItem = (AbstractItem)Jenkins.get().getItemByFullName(parentFullName, AbstractItem.class);
            if (fullNameItem instanceof ItemGroup) {
                parent = (ItemGroup)fullNameItem;
            }
        }
        if (parent != null) {
            return parent.getItemsStream().sorted(Comparator.comparing(Item::getName)).skip(skip.intValue()).limit(limit.intValue()).toList();
        }
        return List.of();
    }

    @Tool(description="Update build display name and/or description")
    public boolean updateBuild(@ToolParam(description="Full path of the Jenkins job (e.g., 'folder/job-name')") String jobFullName, @Nullable @ToolParam(description="Build number (optional, if not provided, updates the last build)", required=false) Integer buildNumber, @Nullable @ToolParam(description="New display name for the build", required=false) String displayName, @Nullable @ToolParam(description="New description for the build", required=false) String description) {
        Optional<Run> optBuild = JenkinsUtil.getBuildByNumberOrLast(jobFullName, buildNumber);
        boolean updated = false;
        if (optBuild.isPresent()) {
            Run build = optBuild.get();
            if (displayName != null && !displayName.isEmpty()) {
                build.setDisplayName(displayName);
                updated = true;
            }
            if (description != null && !description.isEmpty()) {
                build.setDescription(description);
                updated = true;
            }
        }
        return updated;
    }

    @Tool(description="Get information about the currently authenticated user, including their full name or 'anonymous' if not authenticated")
    public Map<String, String> whoAmI() {
        return Optional.ofNullable(User.current()).map(user -> Map.of(FULL_NAME, user.getFullName())).orElse(Map.of(FULL_NAME, "anonymous"));
    }
}

