/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.mcp.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.RootAction;
import hudson.model.User;
import hudson.security.csrf.CrumbExclusion;
import hudson.util.PluginServletFilter;
import io.jenkins.plugins.mcp.server.McpServerExtension;
import io.jenkins.plugins.mcp.server.annotation.Tool;
import io.jenkins.plugins.mcp.server.servlet.UserContextHttpRequest;
import io.jenkins.plugins.mcp.server.tool.McpToolWrapper;
import io.modelcontextprotocol.server.McpServer;
import io.modelcontextprotocol.server.transport.HttpServletSseServerTransportProvider;
import io.modelcontextprotocol.server.transport.HttpServletStreamableServerTransportProvider;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.spec.McpServerTransportProvider;
import io.modelcontextprotocol.spec.McpStreamableServerTransportProvider;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import jenkins.model.JenkinsLocationConfiguration;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
@Extension
public class Endpoint
extends CrumbExclusion
implements RootAction {
    public static final String MCP_SERVER = "mcp-server";
    public static final String SSE_ENDPOINT = "/sse";
    public static final String MCP_SERVER_SSE = "mcp-server/sse";
    public static final String STREAMABLE_ENDPOINT = "/mcp";
    public static final String MCP_SERVER_STREAMABLE = "mcp-server/mcp";
    private static final String MESSAGE_ENDPOINT = "/message";
    public static final String MCP_SERVER_MESSAGE = "mcp-server/message";
    public static final String USER_ID = "userId";
    private final ObjectMapper objectMapper = new ObjectMapper();
    HttpServletSseServerTransportProvider httpServletSseServerTransportProvider;
    HttpServletStreamableServerTransportProvider httpServletStreamableServerTransportProvider;

    public Endpoint() throws ServletException {
        this.init();
    }

    public static String getRequestedResourcePath(HttpServletRequest httpServletRequest) {
        return httpServletRequest.getRequestURI().substring(httpServletRequest.getContextPath().length());
    }

    public boolean process(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        String requestedResource = Endpoint.getRequestedResourcePath(request);
        if (requestedResource.startsWith("/mcp-server/message") && request.getMethod().equalsIgnoreCase("POST")) {
            this.handleMessage(request, response);
            return true;
        }
        if (requestedResource.startsWith("/mcp-server/sse") && request.getMethod().equalsIgnoreCase("POST")) {
            response.sendError(405);
            return true;
        }
        if (this.isStreamableRequest((ServletRequest)request)) {
            this.handleMcpRequest((ServletRequest)request, (ServletResponse)response);
            return true;
        }
        return false;
    }

    protected void init() throws ServletException {
        McpSchema.ServerCapabilities serverCapabilities = McpSchema.ServerCapabilities.builder().tools(Boolean.valueOf(true)).prompts(Boolean.valueOf(true)).resources(Boolean.valueOf(true), Boolean.valueOf(true)).build();
        ExtensionList<McpServerExtension> extensions = McpServerExtension.all();
        List tools = extensions.stream().map(McpServerExtension::getSyncTools).flatMap(Collection::stream).toList();
        List prompts = extensions.stream().map(McpServerExtension::getSyncPrompts).flatMap(Collection::stream).toList();
        List resources = extensions.stream().map(McpServerExtension::getSyncResources).flatMap(Collection::stream).toList();
        List annotationTools = extensions.stream().flatMap(extension -> Arrays.stream(extension.getClass().getMethods()).filter(method -> method.isAnnotationPresent(Tool.class)).map(method -> new McpToolWrapper(this.objectMapper, extension, (Method)method).asSyncToolSpecification())).toList();
        ArrayList allTools = new ArrayList();
        allTools.addAll(tools);
        allTools.addAll(annotationTools);
        String rootUrl = JenkinsLocationConfiguration.get().getUrl();
        if (rootUrl == null) {
            rootUrl = "";
        }
        this.httpServletSseServerTransportProvider = HttpServletSseServerTransportProvider.builder().sseEndpoint(SSE_ENDPOINT).baseUrl(rootUrl).messageEndpoint(MCP_SERVER_MESSAGE).objectMapper(this.objectMapper).build();
        McpServer.sync((McpServerTransportProvider)this.httpServletSseServerTransportProvider).capabilities(serverCapabilities).tools(allTools).prompts(prompts).resources(resources).build();
        this.httpServletStreamableServerTransportProvider = HttpServletStreamableServerTransportProvider.builder().objectMapper(this.objectMapper).mcpEndpoint(STREAMABLE_ENDPOINT).contextExtractor((serverRequest, context) -> {
            Object userId = serverRequest.getAttribute(USER_ID);
            if (userId != null) {
                context.put(USER_ID, userId);
            }
            return context;
        }).build();
        McpServer.sync((McpStreamableServerTransportProvider)this.httpServletStreamableServerTransportProvider).capabilities(serverCapabilities).tools(allTools).prompts(prompts).resources(resources).build();
        PluginServletFilter.addFilter((servletRequest, servletResponse, filterChain) -> {
            if (this.isSSERequest(servletRequest)) {
                this.handleSSE(servletRequest, servletResponse);
            } else if (this.isStreamableRequest(servletRequest)) {
                this.handleMcpRequest(servletRequest, servletResponse);
            } else {
                filterChain.doFilter(servletRequest, servletResponse);
            }
        });
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return MCP_SERVER;
    }

    boolean isSSERequest(ServletRequest servletRequest) {
        if (servletRequest instanceof HttpServletRequest) {
            HttpServletRequest request = (HttpServletRequest)servletRequest;
            String requestedResource = Endpoint.getRequestedResourcePath(request);
            return requestedResource.startsWith("/mcp-server/sse") && request.getMethod().equalsIgnoreCase("GET");
        }
        return false;
    }

    boolean isStreamableRequest(ServletRequest servletRequest) {
        if (servletRequest instanceof HttpServletRequest) {
            HttpServletRequest request = (HttpServletRequest)servletRequest;
            String requestedResource = Endpoint.getRequestedResourcePath(request);
            return requestedResource.startsWith("/mcp-server/mcp") && (request.getMethod().equalsIgnoreCase("GET") || request.getMethod().equalsIgnoreCase("POST"));
        }
        return false;
    }

    protected void handleSSE(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        this.httpServletSseServerTransportProvider.service(request, response);
    }

    protected void handleMessage(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.httpServletSseServerTransportProvider.service((ServletRequest)new UserContextHttpRequest(this.objectMapper, request), (ServletResponse)response);
    }

    private void handleMcpRequest(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        User currentUser = User.current();
        String userId = null;
        if (currentUser != null) {
            userId = currentUser.getId();
        }
        if (userId != null) {
            request.setAttribute(USER_ID, (Object)userId);
        }
        this.httpServletStreamableServerTransportProvider.service(request, response);
    }
}

