/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.orka.helpers;

import hudson.util.FormValidation;
import io.jenkins.plugins.orka.client.HealthCheckResponse;
import io.jenkins.plugins.orka.client.NodeResponse;
import io.jenkins.plugins.orka.client.OrkaClient;
import io.jenkins.plugins.orka.helpers.OrkaClientFactory;
import io.jenkins.plugins.orka.helpers.Utils;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;

public class FormValidator {
    private static final Logger logger = Logger.getLogger(FormValidator.class.getName());
    private OrkaClientFactory clientFactory;

    public FormValidator(OrkaClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    public FormValidation doCheckConfigName(String configName, String orkaEndpoint, String orkaCredentialsId, boolean useJenkinsProxySettings, boolean ignoreSSLErrors, boolean createNewVMConfig) {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        if (createNewVMConfig) {
            try {
                OrkaClient client;
                boolean alreadyInUse;
                if (StringUtils.isNotBlank((String)orkaEndpoint) && orkaCredentialsId != null && (alreadyInUse = (client = this.clientFactory.getOrkaClient(orkaEndpoint, orkaCredentialsId, useJenkinsProxySettings, ignoreSSLErrors)).getVMConfigs().getConfigs().stream().anyMatch(vmc -> vmc.getName().equalsIgnoreCase(configName)))) {
                    return FormValidation.error((String)"Configuration name is already in use");
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Exception in doCheckConfigName", e);
            }
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckMemory(String memory) {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        try {
            if (StringUtils.isBlank((String)memory) || StringUtils.equals((String)memory, (String)"auto")) {
                return FormValidation.ok();
            }
            if (Float.parseFloat(memory) <= 0.0f) {
                return FormValidation.error((String)"Memory should be greater than 0");
            }
            return FormValidation.ok();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception in doCheckMemory", e);
            return FormValidation.error((String)"Memory should be greater than 0");
        }
    }

    public FormValidation doCheckNamespace(String endpoint, String credentialsId, boolean useJenkinsProxySettings, boolean ignoreSSLErrors, String namespace) {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        if (StringUtils.startsWith((String)namespace, (String)"orka-")) {
            try {
                OrkaClient client;
                NodeResponse response;
                if (StringUtils.isNotBlank((String)endpoint) && StringUtils.isNotBlank((String)credentialsId) && !(response = (client = this.clientFactory.getOrkaClient(endpoint, credentialsId, useJenkinsProxySettings, ignoreSSLErrors)).getNodes(namespace)).getHttpResponse().getIsSuccessful()) {
                    if (response.getHttpResponse().getCode() == 403) {
                        return FormValidation.error((String)String.format("The user or service account does not have access to namespace: %s", namespace));
                    }
                    logger.fine(String.format("Check namespace failed with %s", response.getMessage()));
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Exception in doCheckNamespace", e);
            }
            return FormValidation.ok();
        }
        return FormValidation.error((String)"Namespace must start with 'orka-'");
    }

    public FormValidation doTestConnection(String credentialsId, String endpoint, boolean useJenkinsProxySettings, boolean ignoreSSLErrors) throws IOException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        try {
            HealthCheckResponse response = new OrkaClientFactory().getOrkaClient(endpoint, credentialsId, useJenkinsProxySettings, ignoreSSLErrors).getHealthCheck();
            if (!response.isSuccessful()) {
                return FormValidator.failedConnection(Utils.getErrorMessage(response));
            }
        }
        catch (IOException e) {
            return FormValidator.failedConnection(e.getMessage());
        }
        return FormValidation.ok((String)"Connection Successful");
    }

    private static FormValidation failedConnection(String message) {
        return FormValidation.error((String)("Connection failed with: " + message));
    }
}

