/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.orka.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.Gson;
import io.jenkins.plugins.orka.client.ConfigurationRequest;
import io.jenkins.plugins.orka.client.ConfigurationResponse;
import io.jenkins.plugins.orka.client.DeletionResponse;
import io.jenkins.plugins.orka.client.DeploymentRequest;
import io.jenkins.plugins.orka.client.DeploymentResponse;
import io.jenkins.plugins.orka.client.HealthCheckResponse;
import io.jenkins.plugins.orka.client.HttpResponse;
import io.jenkins.plugins.orka.client.ImageResponse;
import io.jenkins.plugins.orka.client.JsonHelper;
import io.jenkins.plugins.orka.client.NodeResponse;
import io.jenkins.plugins.orka.client.SSLHelper;
import io.jenkins.plugins.orka.client.VMConfigResponse;
import java.io.IOException;
import java.net.Proxy;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.lang.StringUtils;

public class OrkaClient {
    private static final OkHttpClient clientBase = new OkHttpClient();
    private static final Logger logger = Logger.getLogger(OrkaClient.class.getName());
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String BEARER = "Bearer ";
    private static final MediaType JSON = MediaType.get((String)"application/json; charset=utf-8");
    private static final String RESOURCE_PATH = "api/v1/namespaces";
    private static final String VM_CONFIG_PATH = "api/v1/namespaces/orka-default/vmconfigs";
    private static final String VM_PATH = "vms";
    private static final String NODE_PATH = "nodes";
    private static final String IMAGE_PATH = "api/v1/namespaces/orka-default/images";
    private String endpoint;
    private String token;
    private OkHttpClient client;

    public OrkaClient(String endpoint, String token, int httpClientTimeout, Proxy proxy, boolean ignoreSSLErrors) throws IOException {
        this.client = this.createClient(proxy, httpClientTimeout, ignoreSSLErrors);
        this.endpoint = endpoint;
        this.token = token;
    }

    public VMConfigResponse getVMConfigs() throws IOException {
        HttpResponse httpResponse = this.get(String.format("%s/%s", this.endpoint, VM_CONFIG_PATH));
        VMConfigResponse response = JsonHelper.fromJson(httpResponse.getBody(), VMConfigResponse.class);
        response.setHttpResponse(httpResponse);
        return response;
    }

    public NodeResponse getNodes(String namespace) throws IOException {
        HttpResponse httpResponse = this.get(String.format("%s/%s/%s/%s", this.endpoint, RESOURCE_PATH, namespace, NODE_PATH));
        NodeResponse response = JsonHelper.fromJson(httpResponse.getBody(), NodeResponse.class);
        response.setHttpResponse(httpResponse);
        return response;
    }

    public ImageResponse getImages() throws IOException {
        HttpResponse httpResponse = this.get(String.format("%s/%s", this.endpoint, IMAGE_PATH));
        ImageResponse response = JsonHelper.fromJson(httpResponse.getBody(), ImageResponse.class);
        response.setHttpResponse(httpResponse);
        return response;
    }

    public ConfigurationResponse createConfiguration(String vmName, String image, int cpu, boolean netBoost, boolean gpuPassthrough, String scheduler, String memory, String tag, Boolean tagRequired) throws IOException {
        ConfigurationRequest configRequest = new ConfigurationRequest(vmName, image, cpu, netBoost, gpuPassthrough, scheduler, memory, tag, tagRequired);
        String configRequestJson = new Gson().toJson((Object)configRequest);
        HttpResponse httpResponse = this.post(String.format("%s/%s", this.endpoint, VM_CONFIG_PATH), configRequestJson);
        ConfigurationResponse response = JsonHelper.fromJson(httpResponse.getBody(), ConfigurationResponse.class);
        response.setHttpResponse(httpResponse);
        return response;
    }

    public DeploymentResponse deployVM(String vmConfig, String namespace, String namePrefix, String image, Integer cpu, String memory, String node, String scheduler, String tag, Boolean tagRequired) throws IOException {
        DeploymentRequest deploymentRequest = new DeploymentRequest(vmConfig, namePrefix, image, cpu, memory, node, scheduler, tag, tagRequired);
        String deploymentRequestJson = new Gson().toJson((Object)deploymentRequest);
        HttpResponse httpResponse = this.post(String.format("%s/%s/%s/%s", this.endpoint, RESOURCE_PATH, namespace, VM_PATH), deploymentRequestJson);
        DeploymentResponse response = JsonHelper.fromJson(httpResponse.getBody(), DeploymentResponse.class);
        response.setHttpResponse(httpResponse);
        return response;
    }

    public DeletionResponse deleteVM(String vmName, String namespace) throws IOException {
        HttpResponse httpResponse = this.delete(String.format("%s/%s/%s/%s/%s", this.endpoint, RESOURCE_PATH, namespace, VM_PATH, vmName));
        String body = httpResponse.getBody();
        DeletionResponse response = StringUtils.isNotBlank((String)body) ? JsonHelper.fromJson(httpResponse.getBody(), DeletionResponse.class) : new DeletionResponse(null);
        response.setHttpResponse(httpResponse);
        return response;
    }

    public HealthCheckResponse getHealthCheck() throws IOException {
        HttpResponse httpResponse = this.get(String.format("%s/%s", this.endpoint, VM_CONFIG_PATH));
        HealthCheckResponse response = JsonHelper.fromJson(httpResponse.getBody(), HealthCheckResponse.class);
        response.setHttpResponse(httpResponse);
        return response;
    }

    @VisibleForTesting
    HttpResponse post(String url, String body) throws IOException {
        RequestBody requestBody = RequestBody.create((String)body, (MediaType)JSON);
        Request request = this.getAuthenticatedBuilder(url).post(requestBody).build();
        return this.executeCall(request);
    }

    @VisibleForTesting
    HttpResponse get(String url) throws IOException {
        Request request = this.getAuthenticatedBuilder(url).get().build();
        return this.executeCall(request);
    }

    @VisibleForTesting
    HttpResponse delete(String url) throws IOException {
        Request request = this.getAuthenticatedBuilder(url).delete().build();
        return this.executeCall(request);
    }

    private Request.Builder getAuthenticatedBuilder(String url) throws IOException {
        Request.Builder builder = new Request.Builder().url(url);
        builder.addHeader(AUTHORIZATION_HEADER, BEARER + this.token);
        return builder;
    }

    private HttpResponse executeCall(Request request) throws IOException {
        return this.executeCallImpl(request);
    }

    private HttpResponse executeCallImpl(Request request) throws IOException {
        logger.fine("Executing request to Orka API: /" + request.method() + ' ' + request.url());
        try (Response response = this.client.newCall(request).execute();){
            ResponseBody body = response.body();
            HttpResponse httpResponse = new HttpResponse(body != null ? body.string() : null, response.code(), response.isSuccessful());
            return httpResponse;
        }
    }

    private OkHttpClient createClient(Proxy proxy, int httpClientTimeout, boolean ignoreSSLErrors) {
        OkHttpClient.Builder builder = ignoreSSLErrors ? SSLHelper.ignoreSSLErrors(clientBase.newBuilder()) : clientBase.newBuilder();
        return builder.readTimeout((long)httpClientTimeout, TimeUnit.SECONDS).protocols(Arrays.asList(Protocol.HTTP_1_1)).proxy(proxy).build();
    }
}

