/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.orka.client;

import com.google.gson.annotations.SerializedName;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.apache.commons.lang.StringUtils;

public class ConfigurationRequest {
    @SerializedName(value="orka_vm_name")
    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
    private String vmName;
    @SerializedName(value="orka_image")
    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
    private String image;
    @SerializedName(value="orka_base_image")
    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
    private String baseImage;
    @SerializedName(value="orka_vm_config_template_name")
    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
    private String configTemplate;
    @SerializedName(value="orka_cpu_core")
    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
    private int cpuCount;
    @SerializedName(value="net_boost")
    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
    private boolean useNetBoost;
    @SerializedName(value="gpu_passthrough")
    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
    private boolean useGpuPassthrough;
    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
    private String scheduler;
    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
    private float memory;
    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
    private String tag;
    @SerializedName(value="tag_required")
    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
    private Boolean tagRequired;

    @Deprecated
    public ConfigurationRequest(String vmName, String image, String baseImage, String configTemplate, int cpuCount) {
        this(vmName, image, baseImage, configTemplate, cpuCount, null);
    }

    @Deprecated
    public ConfigurationRequest(String vmName, String image, String baseImage, String configTemplate, int cpuCount, String scheduler) {
        this(vmName, image, baseImage, configTemplate, cpuCount, scheduler, "auto");
    }

    public ConfigurationRequest(String vmName, String image, String baseImage, String configTemplate, int cpuCount, String scheduler, String memory) {
        this(vmName, image, baseImage, configTemplate, cpuCount, false, false, scheduler, memory, null, null);
    }

    public ConfigurationRequest(String vmName, String image, String baseImage, String configTemplate, int cpuCount, boolean useNetBoost, String scheduler, String memory) {
        this(vmName, image, baseImage, configTemplate, cpuCount, useNetBoost, false, scheduler, memory, null, null);
    }

    public ConfigurationRequest(String vmName, String image, String baseImage, String configTemplate, int cpuCount, boolean useNetBoost, String scheduler, String memory, String tag, Boolean tagRequired) {
        this(vmName, image, baseImage, configTemplate, cpuCount, useNetBoost, false, scheduler, memory, tag, tagRequired);
    }

    public ConfigurationRequest(String vmName, String image, String baseImage, String configTemplate, int cpuCount, boolean useNetBoost, boolean useGpuPassthrough, String scheduler, String memory, String tag, Boolean tagRequired) {
        this.vmName = vmName;
        this.image = image;
        this.baseImage = baseImage;
        this.configTemplate = configTemplate;
        this.cpuCount = cpuCount;
        this.useNetBoost = useNetBoost;
        this.useGpuPassthrough = useGpuPassthrough;
        String string = this.scheduler = StringUtils.isNotBlank((String)scheduler) ? scheduler : null;
        if (!StringUtils.isBlank((String)memory) && !StringUtils.equals((String)memory, (String)"auto") && Float.parseFloat(memory) > 0.0f) {
            this.memory = Float.parseFloat(memory);
        }
        this.tag = StringUtils.isNotBlank((String)tag) && tag != null ? tag : null;
        this.tagRequired = tagRequired != null ? tagRequired : null;
    }
}

