/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.orka;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Executor;
import hudson.model.ExecutorListener;
import hudson.model.Queue;
import hudson.slaves.AbstractCloudComputer;
import hudson.slaves.AbstractCloudSlave;
import hudson.slaves.CloudRetentionStrategy;
import hudson.slaves.RetentionStrategy;
import hudson.util.FormValidation;
import io.jenkins.plugins.orka.helpers.Utils;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class RunOnceCloudRetentionStrategy
extends CloudRetentionStrategy
implements ExecutorListener {
    private static final Logger LOGGER = Logger.getLogger(RunOnceCloudRetentionStrategy.class.getName());
    private int idleMinutes;
    public static final int RECOMMENDED_MIN_IDLE = 1;
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public RunOnceCloudRetentionStrategy(int idleMinutes) {
        super(Utils.normalizeIdleTime(idleMinutes, 1));
        this.idleMinutes = Utils.normalizeIdleTime(idleMinutes, 1);
    }

    public int getIdleMinutes() {
        return this.idleMinutes;
    }

    public void taskAccepted(Executor executor, Queue.Task task) {
    }

    public void taskCompleted(Executor executor, Queue.Task task, long durationMS) {
        this.taskCompleted(executor);
    }

    private void taskCompleted(Executor executor) {
        AbstractCloudComputer computer = (AbstractCloudComputer)executor.getOwner();
        Queue.Executable currentExecutable = executor.getCurrentExecutable();
        LOGGER.log(Level.FINE, "Terminating {0}.Build {1} is finished", new Object[]{computer.getName(), currentExecutable});
        this.taskCompleted(computer);
    }

    private void taskCompleted(AbstractCloudComputer<?> computer) {
        computer.setAcceptingTasks(false);
        AbstractCloudSlave computerNode = computer.getNode();
        if (computerNode != null) {
            try {
                computerNode.terminate();
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.WARNING, "Failed to terminate " + computer.getName(), e);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to terminate " + computer.getName(), e);
            }
        }
    }

    public void taskCompletedWithProblems(Executor executor, Queue.Task task, long durationMS, Throwable problems) {
        this.taskCompleted(executor);
    }

    public DescriptorImpl getDescriptor() {
        return DESCRIPTOR;
    }

    public String toString() {
        return "RunOnceCloudRetentionStrategy [idleMinutes=" + this.idleMinutes + "]";
    }

    private Object readResolve() {
        this.idleMinutes = Utils.normalizeIdleTime(this.idleMinutes, 1);
        return new RunOnceCloudRetentionStrategy(this.idleMinutes);
    }

    public static final class DescriptorImpl
    extends Descriptor<RetentionStrategy<?>> {
        public String getDisplayName() {
            return "Terminate immediately after use";
        }

        public FormValidation doCheckIdleMinutes(@QueryParameter String value) {
            return Utils.checkInputValue(value);
        }
    }
}

