/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.orka;

import com.cloudbees.plugins.credentials.common.StandardCredentials;
import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Label;
import hudson.model.Node;
import hudson.slaves.Cloud;
import hudson.slaves.NodeProvisioner;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.orka.AddressMapper;
import io.jenkins.plugins.orka.AgentTemplate;
import io.jenkins.plugins.orka.OrkaProvisionedAgent;
import io.jenkins.plugins.orka.client.ConfigurationResponse;
import io.jenkins.plugins.orka.client.DeletionResponse;
import io.jenkins.plugins.orka.client.DeploymentResponse;
import io.jenkins.plugins.orka.client.OrkaVM;
import io.jenkins.plugins.orka.client.OrkaVMConfig;
import io.jenkins.plugins.orka.helpers.CapacityHandler;
import io.jenkins.plugins.orka.helpers.CredentialsHelper;
import io.jenkins.plugins.orka.helpers.FormValidator;
import io.jenkins.plugins.orka.helpers.OrkaClientProxyFactory;
import io.jenkins.plugins.orka.helpers.Utils;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class OrkaCloud
extends Cloud {
    private static final Logger logger = Logger.getLogger(OrkaCloud.class.getName());
    private static final int recommendedMinTimeout = 30;
    private static final int defaultTimeout = 600;
    private static final int defaultHttpTimeout = 300;
    private String credentialsId;
    private String endpoint;
    private int instanceCap;
    private String instanceCapSetting;
    private int timeout;
    private int httpTimeout;
    private boolean useJenkinsProxySettings;
    private boolean ignoreSSLErrors;
    private boolean noDelayProvisioning;
    private List<? extends AddressMapper> mappings;
    private final List<? extends AgentTemplate> templates;
    private transient CapacityHandler capacityHandler;

    public OrkaCloud(String name, String credentialsId, String endpoint, String instanceCapSetting, int timeout, boolean useJenkinsProxySettings, List<? extends AddressMapper> mappings, List<? extends AgentTemplate> templates) {
        this(name, credentialsId, endpoint, instanceCapSetting, timeout, useJenkinsProxySettings, false, mappings, templates);
    }

    public OrkaCloud(String name, String credentialsId, String endpoint, String instanceCapSetting, int timeout, boolean useJenkinsProxySettings, boolean ignoreSSLErrors, List<? extends AddressMapper> mappings, List<? extends AgentTemplate> templates) {
        this(name, credentialsId, endpoint, instanceCapSetting, timeout, 300, useJenkinsProxySettings, ignoreSSLErrors, mappings, templates);
    }

    public OrkaCloud(String name, String credentialsId, String endpoint, String instanceCapSetting, int timeout, int httpTimeout, boolean useJenkinsProxySettings, boolean ignoreSSLErrors, List<? extends AddressMapper> mappings, List<? extends AgentTemplate> templates) {
        this(name, credentialsId, endpoint, instanceCapSetting, timeout, 300, useJenkinsProxySettings, ignoreSSLErrors, false, mappings, templates);
    }

    @DataBoundConstructor
    public OrkaCloud(String name, String credentialsId, String endpoint, String instanceCapSetting, int timeout, int httpTimeout, boolean useJenkinsProxySettings, boolean ignoreSSLErrors, boolean noDelayProvisioning, List<? extends AddressMapper> mappings, List<? extends AgentTemplate> templates) {
        super(name);
        this.credentialsId = credentialsId;
        this.endpoint = endpoint;
        this.instanceCapSetting = instanceCapSetting;
        this.timeout = timeout;
        this.httpTimeout = httpTimeout;
        this.useJenkinsProxySettings = useJenkinsProxySettings;
        this.ignoreSSLErrors = ignoreSSLErrors;
        this.noDelayProvisioning = noDelayProvisioning;
        this.mappings = mappings;
        this.templates = templates == null ? Collections.emptyList() : templates;
        this.readResolve();
    }

    protected Object readResolve() {
        this.templates.forEach(t -> t.setParent(this));
        this.mappings = this.mappings == null ? Collections.emptyList() : this.mappings;
        this.instanceCap = StringUtils.isEmpty((String)this.instanceCapSetting) ? Integer.MAX_VALUE : Integer.parseInt(this.instanceCapSetting);
        this.capacityHandler = new CapacityHandler(this.name, this.instanceCap);
        this.timeout = this.timeout > 0 ? this.timeout : 600;
        this.httpTimeout = this.httpTimeout > 0 ? this.httpTimeout : 300;
        return this;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public boolean getUseJenkinsProxySettings() {
        return this.useJenkinsProxySettings;
    }

    public boolean getIgnoreSSLErrors() {
        return this.ignoreSSLErrors;
    }

    public String getInstanceCapSetting() {
        return this.instanceCap == Integer.MAX_VALUE ? "" : String.valueOf(this.instanceCap);
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getHttpTimeout() {
        return this.httpTimeout;
    }

    public List<? extends AddressMapper> getMappings() {
        return this.mappings;
    }

    public List<? extends AgentTemplate> getTemplates() {
        return this.templates;
    }

    public boolean getNoDelayProvisioning() {
        return this.noDelayProvisioning;
    }

    public boolean canProvision(Label label) {
        return this.getTemplate(label) != null;
    }

    public AgentTemplate getTemplate(Label label) {
        return this.templates.stream().filter(t -> this.normalModeOrMatches((AgentTemplate)t, label) || this.exclusiveModeAndMatches((AgentTemplate)t, label)).findFirst().orElse(null);
    }

    public List<OrkaVM> getVMs() throws IOException {
        return new OrkaClientProxyFactory().getOrkaClientProxy(this.endpoint, this.credentialsId, this.httpTimeout, this.useJenkinsProxySettings, this.ignoreSSLErrors).getVMs();
    }

    public List<OrkaVMConfig> getVMConfigs() throws IOException {
        return new OrkaClientProxyFactory().getOrkaClientProxy(this.endpoint, this.credentialsId, this.httpTimeout, this.useJenkinsProxySettings, this.ignoreSSLErrors).getVMConfigs();
    }

    public ConfigurationResponse createConfiguration(String name, String image, String baseImage, String configTemplate, int cpuCount) throws IOException {
        return this.createConfiguration(name, image, baseImage, configTemplate, cpuCount, null);
    }

    public ConfigurationResponse createConfiguration(String name, String image, String baseImage, String configTemplate, int cpuCount, String scheduler) throws IOException {
        return this.createConfiguration(name, image, baseImage, configTemplate, cpuCount, scheduler, "auto");
    }

    public ConfigurationResponse createConfiguration(String name, String image, String baseImage, String configTemplate, int cpuCount, String scheduler, String memory) throws IOException {
        return this.createConfiguration(name, image, baseImage, configTemplate, cpuCount, false, false, scheduler, memory);
    }

    public ConfigurationResponse createConfiguration(String name, String image, String baseImage, String configTemplate, int cpuCount, boolean useNetBoost, String scheduler, String memory) throws IOException {
        return this.createConfiguration(name, image, baseImage, configTemplate, cpuCount, useNetBoost, false, scheduler, memory, null, null);
    }

    public ConfigurationResponse createConfiguration(String name, String image, String baseImage, String configTemplate, int cpuCount, boolean useNetBoost, boolean useGpuPassthrough, String scheduler, String memory) throws IOException {
        return this.createConfiguration(name, image, baseImage, configTemplate, cpuCount, useNetBoost, useGpuPassthrough, scheduler, memory, null, null);
    }

    public ConfigurationResponse createConfiguration(String name, String image, String baseImage, String configTemplate, int cpuCount, boolean useNetBoost, boolean useGpuPassthrough, String scheduler, String memory, String tag, Boolean tagRequired) throws IOException {
        return new OrkaClientProxyFactory().getOrkaClientProxy(this.endpoint, this.credentialsId, this.httpTimeout, this.useJenkinsProxySettings, this.ignoreSSLErrors).createConfiguration(name, image, baseImage, configTemplate, cpuCount, useNetBoost, useGpuPassthrough, scheduler, memory, tag, tagRequired);
    }

    public DeploymentResponse deployVM(String name) throws IOException {
        return this.deployVM(name, null);
    }

    public DeploymentResponse deployVM(String name, String scheduler) throws IOException {
        return this.deployVM(name, scheduler, null, null);
    }

    public DeploymentResponse deployVM(String name, String scheduler, String tag, Boolean tagRequired) throws IOException {
        return new OrkaClientProxyFactory().getOrkaClientProxy(this.endpoint, this.credentialsId, this.timeout, this.useJenkinsProxySettings, this.ignoreSSLErrors).deployVM(name, null, scheduler, tag, tagRequired);
    }

    public void deleteVM(String name) throws IOException {
        try {
            DeletionResponse deletionResponse = new OrkaClientProxyFactory().getOrkaClientProxy(this.endpoint, this.credentialsId, this.httpTimeout, this.useJenkinsProxySettings, this.ignoreSSLErrors).deleteVM(name);
            if (deletionResponse.isSuccessful()) {
                logger.info("VM " + name + " is successfully deleted.");
                this.capacityHandler.removeRunningInstance();
            } else {
                logger.warning("Deleting VM " + name + " failed with: " + Utils.getErrorMessage(deletionResponse));
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Failed to delete a VM with name" + name, ex);
        }
    }

    public String getRealHost(String host) {
        return this.mappings.stream().filter(m -> m.getDefaultHost().equalsIgnoreCase(host)).findFirst().map(m -> m.getRedirectHost()).orElse(host);
    }

    public Collection<NodeProvisioner.PlannedNode> provision(Label label, int excessWorkload) {
        String provisionIdString = "[provisionId=" + UUID.randomUUID().toString() + "] ";
        try {
            String labelName = label != null ? label.getName() : "";
            logger.info(provisionIdString + "Provisioning for label " + labelName + ". Workload: " + excessWorkload);
            AgentTemplate template = this.getTemplate(label);
            if (template == null) {
                logger.fine(provisionIdString + "Couldn't find template for label " + labelName + ". Stopping provisioning.");
                return Collections.emptyList();
            }
            int vmsToProvision = Math.max(excessWorkload / template.getNumExecutors(), 1);
            int possibleVMsToProvision = this.capacityHandler.reserveCapacity(vmsToProvision, provisionIdString);
            logger.fine(String.format("%s. Asked for %s VMs and got %s", provisionIdString, vmsToProvision, possibleVMsToProvision));
            return IntStream.range(0, possibleVMsToProvision).mapToObj(i -> {
                String nodeName = UUID.randomUUID().toString();
                Callable<Node> provisionNodeCallable = this.provisionNode(template, provisionIdString, this.capacityHandler);
                Future<Node> provisionNodeTask = Computer.threadPoolForRemoting.submit(provisionNodeCallable);
                return new NodeProvisioner.PlannedNode(nodeName, provisionNodeTask, template.getNumExecutors());
            }).collect(Collectors.toList());
        }
        catch (Exception e) {
            logger.log(Level.WARNING, provisionIdString + "Exception during provisioning", e);
            return Collections.emptyList();
        }
    }

    private Callable<Node> provisionNode(final AgentTemplate template, final String provisionIdString, final CapacityHandler capacityHandler) {
        return new Callable<Node>(){

            @Override
            public Node call() throws Exception {
                logger.fine(provisionIdString + "Provisioning Node with template:");
                logger.fine(template.toString());
                OrkaProvisionedAgent agent = null;
                try {
                    agent = template.provision();
                }
                catch (Exception e) {
                    capacityHandler.removeFailedPlannedInstance();
                    logger.log(Level.WARNING, "Exception during provision", e);
                    throw e;
                }
                if (agent != null) {
                    logger.fine(provisionIdString + "Adding Node to Jenkins:");
                    logger.fine(agent.toString());
                    capacityHandler.addRunningInstance();
                } else {
                    capacityHandler.removeFailedPlannedInstance();
                }
                return agent;
            }
        };
    }

    private boolean normalModeOrMatches(AgentTemplate template, Label label) {
        return template.getMode() == Node.Mode.NORMAL && (label == null || label.matches(template.getLabelSet()));
    }

    private boolean exclusiveModeAndMatches(AgentTemplate template, Label label) {
        return template.getMode() == Node.Mode.EXCLUSIVE && label != null && label.matches(template.getLabelSet());
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<Cloud> {
        private OrkaClientProxyFactory clientProxyFactory = new OrkaClientProxyFactory();
        private FormValidator formValidator = new FormValidator(this.clientProxyFactory);

        public String getDisplayName() {
            return "Orka Cloud";
        }

        public int getDefaultTimeout() {
            return 600;
        }

        public int getDefaultHttpTimeout() {
            return 300;
        }

        public ListBoxModel doFillCredentialsIdItems() {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            return CredentialsHelper.getCredentials(StandardCredentials.class);
        }

        public FormValidation doCheckTimeout(@QueryParameter String value) {
            try {
                int timeoutValue = Integer.parseInt(value);
                if (0 < timeoutValue && timeoutValue < 30) {
                    return FormValidation.warning((String)String.format("Deployment timeout less than %d seconds is not recommended.", 30));
                }
                if (timeoutValue <= 0) {
                    return FormValidation.error((String)"Deployment timeout must be a positive number.");
                }
                return FormValidation.ok();
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)"Deployment timeout must be a number.");
            }
        }

        public FormValidation doCheckHttpTimeout(@QueryParameter String value) {
            try {
                int timeoutValue = Integer.parseInt(value);
                if (0 < timeoutValue && timeoutValue < 30) {
                    return FormValidation.warning((String)String.format("HTTP timeout less than %d seconds is not recommended.", 30));
                }
                if (timeoutValue <= 0) {
                    return FormValidation.error((String)"HTTP timeout must be a positive number.");
                }
                return FormValidation.ok();
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)"HTTP timeout must be a number.");
            }
        }

        @POST
        public FormValidation doTestConnection(@QueryParameter String credentialsId, @QueryParameter String endpoint, @QueryParameter boolean useJenkinsProxySettings, @QueryParameter boolean ignoreSSLErrors) throws IOException {
            return this.formValidator.doTestConnection(credentialsId, endpoint, useJenkinsProxySettings, ignoreSSLErrors);
        }
    }
}

