/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.orka.helpers;

import java.security.Key;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;

public class AESDecryptor {
    private static final Logger logger = Logger.getLogger(AESDecryptor.class.getName());
    private static final int INDEX_KEY = 0;
    private static final int INDEX_IV = 1;
    private static final int ITERATIONS = 1;
    private static final int SALT_OFFSET = 8;
    private static final int SALT_SIZE = 8;
    private static final int CIPHERTEXT_OFFSET = 16;
    private static final String CIPHER_TRANSFORMATION = "AES/CBC/PKCS5Padding";
    private static final String DIGEST = "MD5";
    private static final String AES = "AES";
    private static final int KEY_SIZE_BITS = 256;

    public static String decrypt(String cypherText, String password) {
        try {
            byte[] dataBase64 = DatatypeConverter.parseBase64Binary((String)cypherText);
            byte[] salt = Arrays.copyOfRange(dataBase64, 8, 16);
            byte[] encrypted = Arrays.copyOfRange(dataBase64, 16, dataBase64.length);
            Cipher cipher = Cipher.getInstance(CIPHER_TRANSFORMATION);
            MessageDigest sha1 = MessageDigest.getInstance(DIGEST);
            byte[][] keyAndIV = AESDecryptor.EVP_BytesToKey(32, cipher.getBlockSize(), sha1, salt, password.getBytes("ASCII"), 1);
            SecretKeySpec key = new SecretKeySpec(keyAndIV[0], AES);
            IvParameterSpec iv = new IvParameterSpec(keyAndIV[1]);
            cipher.init(2, (Key)key, iv);
            byte[] decrypted = cipher.doFinal(encrypted);
            String answer = new String(decrypted, "UTF-8");
            return answer;
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Decryption failed", ex);
            return null;
        }
    }

    private static byte[][] EVP_BytesToKey(int key_len, int iv_len, MessageDigest md, byte[] salt, byte[] data, int count) {
        byte[][] both = new byte[2][];
        byte[] key = new byte[key_len];
        int key_ix = 0;
        byte[] iv = new byte[iv_len];
        int iv_ix = 0;
        both[0] = key;
        both[1] = iv;
        byte[] md_buf = null;
        int nkey = key_len;
        int niv = iv_len;
        int i = 0;
        if (data == null) {
            return both;
        }
        int addmd = 0;
        do {
            md.reset();
            if (addmd++ > 0) {
                md.update(md_buf);
            }
            md.update(data);
            if (null != salt) {
                md.update(salt, 0, 8);
            }
            md_buf = md.digest();
            for (i = 1; i < count; ++i) {
                md.reset();
                md.update(md_buf);
                md_buf = md.digest();
            }
            if (nkey > 0) {
                for (i = 0; nkey != 0 && i != md_buf.length; --nkey, ++i) {
                    key[key_ix++] = md_buf[i];
                }
            }
            if (niv <= 0 || i == md_buf.length) continue;
            while (niv != 0 && i != md_buf.length) {
                iv[iv_ix++] = md_buf[i];
                --niv;
                ++i;
            }
        } while (nkey != 0 || niv != 0);
        for (i = 0; i < md_buf.length; ++i) {
            md_buf[i] = 0;
        }
        return both;
    }
}

