/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.orka.helpers;

import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import hudson.ProxyConfiguration;
import hudson.util.Secret;
import io.jenkins.plugins.orka.client.ConfigurationResponse;
import io.jenkins.plugins.orka.client.DeletionResponse;
import io.jenkins.plugins.orka.client.DeploymentResponse;
import io.jenkins.plugins.orka.client.OrkaClient;
import io.jenkins.plugins.orka.client.OrkaNode;
import io.jenkins.plugins.orka.client.OrkaVM;
import io.jenkins.plugins.orka.client.OrkaVMConfig;
import io.jenkins.plugins.orka.client.TokenStatusResponse;
import io.jenkins.plugins.orka.helpers.CredentialsHelper;
import java.io.IOException;
import java.net.Proxy;
import java.util.List;
import jenkins.model.Jenkins;

public class OrkaClientProxy {
    private StandardUsernamePasswordCredentials credentials;
    private String endpoint;
    private int httpClientTimeout;
    private boolean ignoreSSLErrors;
    private Proxy proxy;

    public OrkaClientProxy(String endpoint, String credentialsId, int httpClientTimeout, boolean useJenkinsProxySettings) {
        this(endpoint, credentialsId, httpClientTimeout, useJenkinsProxySettings, false);
    }

    public OrkaClientProxy(String endpoint, String credentialsId, int httpClientTimeout, boolean useJenkinsProxySettings, boolean ignoreSSLErrors) {
        this.credentials = CredentialsHelper.lookupSystemCredentials(credentialsId);
        this.endpoint = endpoint;
        this.httpClientTimeout = httpClientTimeout;
        this.proxy = this.getProxy(useJenkinsProxySettings);
        this.ignoreSSLErrors = ignoreSSLErrors;
    }

    public List<OrkaVM> getVMs() throws IOException {
        try (OrkaClient client = this.getOrkaClient();){
            List<OrkaVM> list = client.getVMs().getVMs();
            return list;
        }
    }

    public List<OrkaVMConfig> getVMConfigs() throws IOException {
        try (OrkaClient client = this.getOrkaClient();){
            List<OrkaVMConfig> list = client.getVMConfigs().getConfigs();
            return list;
        }
    }

    public List<OrkaNode> getNodes() throws IOException {
        try (OrkaClient client = this.getOrkaClient();){
            List<OrkaNode> list = client.getNodes().getNodes();
            return list;
        }
    }

    public List<String> getImages() throws IOException {
        try (OrkaClient client = this.getOrkaClient();){
            List<String> list = client.getImages().getImages();
            return list;
        }
    }

    public ConfigurationResponse createConfiguration(String vmName, String image, String baseImage, String configTemplate, int cpuCount) throws IOException {
        try (OrkaClient client = this.getOrkaClient();){
            ConfigurationResponse configurationResponse = client.createConfiguration(vmName, image, baseImage, configTemplate, cpuCount);
            return configurationResponse;
        }
    }

    public DeploymentResponse deployVM(String vmName) throws IOException {
        try (OrkaClient client = this.getOrkaClient();){
            DeploymentResponse deploymentResponse = client.deployVM(vmName);
            return deploymentResponse;
        }
    }

    public DeploymentResponse deployVM(String vmName, String node) throws IOException {
        try (OrkaClient client = this.getOrkaClient();){
            DeploymentResponse deploymentResponse = client.deployVM(vmName, node);
            return deploymentResponse;
        }
    }

    public DeletionResponse deleteVM(String vmName) throws IOException {
        try (OrkaClient client = this.getOrkaClient();){
            DeletionResponse deletionResponse = client.deleteVM(vmName);
            return deletionResponse;
        }
    }

    public DeletionResponse deleteVM(String vmName, String node) throws IOException {
        try (OrkaClient client = this.getOrkaClient();){
            DeletionResponse deletionResponse = client.deleteVM(vmName, node);
            return deletionResponse;
        }
    }

    public TokenStatusResponse getTokenStatus() throws IOException {
        try (OrkaClient client = this.getOrkaClient();){
            TokenStatusResponse tokenStatusResponse = client.getTokenStatus();
            return tokenStatusResponse;
        }
    }

    private OrkaClient getOrkaClient() throws IOException {
        return new OrkaClient(this.endpoint, this.credentials.getUsername(), Secret.toString((Secret)this.credentials.getPassword()), this.httpClientTimeout, this.proxy, this.ignoreSSLErrors);
    }

    private Proxy getProxy(boolean useJenkinsProxySettings) {
        if (useJenkinsProxySettings) {
            ProxyConfiguration proxyConfig = Jenkins.get().proxy;
            return proxyConfig == null ? Proxy.NO_PROXY : proxyConfig.createProxy(this.endpoint);
        }
        return Proxy.NO_PROXY;
    }
}

