/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.LogFlowVisualizer.input;

import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.util.FormValidation;
import io.jenkins.plugins.LogFlowVisualizer.input.LogFlowInput;
import io.jenkins.plugins.LogFlowVisualizer.input.LogFlowInputDescriptor;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;
import org.springframework.lang.NonNull;

public class LogFlowInputSimple
extends LogFlowInput {
    private final String regex;
    private final Boolean deleteMark;

    @DataBoundConstructor
    public LogFlowInputSimple(String regex, Boolean deleteMark) {
        this.regex = regex;
        this.deleteMark = deleteMark;
    }

    public String getRegex() {
        return this.regex;
    }

    public Boolean getDeleteMark() {
        return this.deleteMark;
    }

    public DescriptorExtensionList<LogFlowInput, LogFlowInputDescriptor> getFormatDescriptors() {
        return Jenkins.get().getDescriptorList(LogFlowInput.class);
    }

    @Extension
    @Symbol(value={"simpleInput"})
    public static final class DescriptorImpl
    extends LogFlowInputDescriptor {
        @POST
        public FormValidation doCheckRegex(@QueryParameter String regex) {
            if (regex.isEmpty()) {
                return FormValidation.error((String)"Regex is empty");
            }
            try {
                Pattern.compile(regex);
            }
            catch (PatternSyntaxException exception) {
                return FormValidation.error((String)"Regex is invalid");
            }
            return FormValidation.ok();
        }

        @NonNull
        public String getDisplayName() {
            return "Simple Regex Format";
        }
    }
}

