/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.LogFlowVisualizer.input;

import hudson.Extension;
import hudson.util.FormValidation;
import io.jenkins.plugins.LogFlowVisualizer.input.LogFlowInput;
import io.jenkins.plugins.LogFlowVisualizer.input.LogFlowInputDescriptor;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;
import org.springframework.lang.NonNull;

public class LogFlowInputAdvanced
extends LogFlowInput {
    private static final int DEFAULT_CONTENT_LENGTH = 30;
    private final String startMark;
    private final String endMark;
    private final Boolean deleteMark;
    private int maxContentLength = 30;
    private int numberOfLineToDisplay = 0;

    @DataBoundConstructor
    public LogFlowInputAdvanced(String startMark, String endMark, Boolean deleteMark, int maxContentLength, int numberOfLineToDisplay) {
        this.startMark = startMark;
        this.endMark = endMark;
        this.deleteMark = deleteMark;
        this.maxContentLength = maxContentLength;
        this.numberOfLineToDisplay = numberOfLineToDisplay;
    }

    public String getStartMark() {
        return this.startMark;
    }

    public String getEndMark() {
        return this.endMark;
    }

    public Boolean getDeleteMark() {
        return this.deleteMark;
    }

    public int getMaxContentLength() {
        return this.maxContentLength;
    }

    public int getNumberOfLineToDisplay() {
        return this.numberOfLineToDisplay;
    }

    @Extension
    @Symbol(value={"advancedInput"})
    public static final class DescriptorImpl
    extends LogFlowInputDescriptor {
        @POST
        public FormValidation doCheckStartMark(@QueryParameter String startMark) {
            if (startMark.isEmpty()) {
                return FormValidation.error((String)"Regex is empty");
            }
            try {
                Pattern.compile(startMark);
            }
            catch (PatternSyntaxException exception) {
                return FormValidation.error((String)"Regex is invalid");
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckEndMark(@QueryParameter String endMark) {
            if (endMark.isEmpty()) {
                return FormValidation.error((String)"Regex is empty");
            }
            try {
                Pattern.compile(endMark);
            }
            catch (PatternSyntaxException exception) {
                return FormValidation.error((String)"Regex is invalid");
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckMaxContentLength(@QueryParameter String maxContentLength) {
            try {
                int inputNumber = Integer.parseInt(maxContentLength);
                if (inputNumber < 1) {
                    return FormValidation.error((String)"Max content length should be greater than 0");
                }
                return FormValidation.ok();
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)"Couldn't parse number input");
            }
            catch (Exception e) {
                return FormValidation.error((String)"Something went wrong");
            }
        }

        @POST
        public FormValidation doCheckNumberOfLineToDisplay(@QueryParameter String numberOfLineToDisplay) {
            try {
                int inputNumber = Integer.parseInt(numberOfLineToDisplay);
                if (inputNumber < 0) {
                    return FormValidation.error((String)"Number of line to display should be 0 or greater");
                }
                return FormValidation.ok();
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)"Couldn't parse number input");
            }
            catch (Exception e) {
                return FormValidation.error((String)"Something went wrong");
            }
        }

        @NonNull
        public String getDisplayName() {
            return "Advanced Regex Format";
        }
    }
}

