/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.LogFlowVisualizer.actions;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import hudson.model.Action;
import hudson.model.Run;
import io.jenkins.plugins.LogFlowVisualizer.input.LogFlowInput;
import io.jenkins.plugins.LogFlowVisualizer.model.HistoryType;
import io.jenkins.plugins.LogFlowVisualizer.model.LineOutput;
import io.jenkins.plugins.LogFlowVisualizer.model.OutputHistoryMarked;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;

public class LogFlowProjectAction
implements SimpleBuildStep.LastBuildAction {
    private final Run<?, ?> run;
    private final List<LogFlowInput> configurations;
    private final File cacheFile;
    private final Boolean compareAgainstLastStableBuild;

    public LogFlowProjectAction(Run<?, ?> run, List<LogFlowInput> configurations, File cacheFolder, Boolean compareAgainstLastStableBuild) {
        this.run = run;
        this.configurations = configurations;
        this.cacheFile = cacheFolder;
        this.compareAgainstLastStableBuild = compareAgainstLastStableBuild;
    }

    public File getCacheFile() {
        return this.cacheFile;
    }

    public List<LineOutput> getAllCacheFromFile() {
        return this.getAllCacheFromNamedFile(this.cacheFile);
    }

    public List<OutputHistoryMarked> getHistoryMarkedLines() {
        File comparingFile = this.compareAgainstLastStableBuild != false ? this.getLastStableBuildFile() : this.getPreviousBuildFile();
        List<LineOutput> currentBuildLines = this.getAllCacheFromFile();
        List<LineOutput> previousBuildLines = this.getAllCacheFromNamedFile(comparingFile);
        ArrayList<OutputHistoryMarked> result = new ArrayList<OutputHistoryMarked>();
        for (int lineIndex = 0; lineIndex < currentBuildLines.size(); ++lineIndex) {
            LineOutput currentLine = currentBuildLines.get(lineIndex);
            LineOutput previousLine = previousBuildLines.get(lineIndex);
            if (!currentLine.getDisplay().booleanValue() && !previousLine.getDisplay().booleanValue()) continue;
            if (Objects.equals(currentLine.getLine(), previousLine.getLine())) {
                result.add(new OutputHistoryMarked(currentLine.getRegex(), currentLine.getLine(), currentLine.getIndex(), currentLine.getDeleteMark(), currentLine.getType(), HistoryType.SAME, currentLine.getLineStartOffset(), currentLine.getDisplay()));
                continue;
            }
            if (Objects.equals(currentLine.getRegex(), previousLine.getRegex())) {
                result.add(new OutputHistoryMarked(currentLine.getRegex(), currentLine.getLine(), currentLine.getIndex(), currentLine.getDeleteMark(), currentLine.getType(), HistoryType.JUST_SAME_REGEX, currentLine.getLineStartOffset(), currentLine.getDisplay()));
                continue;
            }
            result.add(new OutputHistoryMarked(currentLine.getRegex(), currentLine.getLine(), currentLine.getIndex(), currentLine.getDeleteMark(), currentLine.getType(), HistoryType.DIFFERENT_CURRENT, currentLine.getLineStartOffset(), currentLine.getDisplay()));
            result.add(new OutputHistoryMarked(previousLine.getRegex(), previousLine.getLine(), previousLine.getIndex(), previousLine.getDeleteMark(), previousLine.getType(), HistoryType.DIFFERENT_PREVIOUS, previousLine.getLineStartOffset(), previousLine.getDisplay()));
        }
        return result;
    }

    public List<LineOutput> getOnlyMarkedLinesToDisplay() {
        List<LineOutput> list = this.getAllCacheFromFile();
        ArrayList<LineOutput> result = new ArrayList<LineOutput>();
        for (LineOutput line : list) {
            if (!line.getDisplay().booleanValue()) continue;
            result.add(line);
        }
        return result;
    }

    private File getPreviousBuildFile() {
        Run previousBuild = this.getRun().getPreviousBuild();
        if (Objects.isNull(previousBuild)) {
            return null;
        }
        int buildNumber = previousBuild.getNumber();
        File buildFolder = this.getBuildFolderFromBuildNumber(buildNumber);
        return new File(buildFolder + File.separator + "LogFlowVisualizerCache.json");
    }

    private File getLastStableBuildFile() {
        Run previousLastStableBuild = this.getRun().getPreviousCompletedBuild();
        if (Objects.isNull(previousLastStableBuild)) {
            return null;
        }
        int buildNumber = previousLastStableBuild.getNumber();
        File buildFolder = this.getBuildFolderFromBuildNumber(buildNumber);
        return new File(buildFolder + File.separator + "LogFlowVisualizerCache.json");
    }

    public File getProjectDirFile() {
        return this.run.getRootDir();
    }

    public File getBuildFolderFromBuildNumber(int buildNumber) {
        return new File(this.getProjectDirFile() + File.separator + "builds" + File.separator + buildNumber);
    }

    private List<LineOutput> getAllCacheFromNamedFile(File file) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            return (List)objectMapper.readValue(file, (TypeReference)new TypeReference<List<LineOutput>>(){});
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getJenkinsRootUrl() {
        Jenkins instance = Jenkins.getInstanceOrNull();
        if (instance == null) {
            return "";
        }
        return instance.getRootUrlFromRequest();
    }

    public Run<?, ?> getRun() {
        return this.run;
    }

    public List<LogFlowInput> getConfigurations() {
        return this.configurations;
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return "LFV";
    }

    public Collection<? extends Action> getProjectActions() {
        ArrayList<LogFlowProjectAction> list = new ArrayList<LogFlowProjectAction>();
        list.add(new LogFlowProjectAction(this.getRun(), this.getConfigurations(), this.getCacheFile(), this.compareAgainstLastStableBuild));
        return list;
    }
}

