/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.LogFlowVisualizer.actions;

import hudson.model.Action;
import hudson.model.Run;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collection;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.WebMethod;
import org.kohsuke.stapler.verb.GET;

public class LogFlowOffsetAction
implements SimpleBuildStep.LastBuildAction {
    private final Run run;

    public LogFlowOffsetAction(Run<?, ?> run) {
        this.run = run;
    }

    @GET
    @WebMethod(name={"get-search-offset"})
    public void doSearchOffset(StaplerRequest req, StaplerResponse res) throws IOException {
        long from;
        Jenkins.get().checkPermission(Jenkins.READ);
        res.setContentType("text/plain");
        res.setCharacterEncoding("UTF-8");
        PrintWriter out = res.getWriter();
        try {
            from = Long.parseLong(req.getParameter("from"));
            long l = Long.parseLong(req.getParameter("to"));
        }
        catch (NumberFormatException e) {
            res.setStatus(404);
            out.print("Couldn't parse input");
            return;
        }
        from = Long.parseLong(req.getParameter("from"));
        long to = Long.parseLong(req.getParameter("to"));
        RandomAccessFile logs = new RandomAccessFile(this.run.getRootDir() + File.separator + "log", "r");
        Long checkFrom = from;
        Long checkTo = to;
        ArrayList<String> resultLines = new ArrayList<String>();
        if (from > to || from < 0L || to < 0L || checkFrom == null || checkTo == null) {
            res.setStatus(404);
            out.print("Invalid parameters");
        } else {
            String line;
            logs.seek(from);
            while ((line = logs.readLine()) != null) {
                resultLines.add(line);
                if (logs.getFilePointer() < to) continue;
            }
            for (String resultLine : resultLines) {
                out.println(resultLine);
            }
        }
        out.flush();
        logs.close();
    }

    public Collection<? extends Action> getProjectActions() {
        return new ArrayList();
    }

    public String getIconFileName() {
        return "symbol-logs";
    }

    public String getDisplayName() {
        return "Log Flow Visualizer Offset Logs";
    }

    public String getUrlName() {
        return "logsOffset";
    }
}

