/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.LogFlowVisualizer.actions;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.difflib.text.DiffRow;
import com.github.difflib.text.DiffRowGenerator;
import hudson.model.Action;
import hudson.model.Run;
import io.jenkins.plugins.LogFlowVisualizer.model.LineOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import jenkins.tasks.SimpleBuildStep;

public class LogFlowHistoryDiffAction
implements SimpleBuildStep.LastBuildAction {
    private final Run<?, ?> run;
    private final File cacheFile;
    private Boolean compareAgainstLastStableBuild = false;

    public LogFlowHistoryDiffAction(Run<?, ?> run, File cacheFile, Boolean compareAgainstLastStableBuild) {
        this.run = run;
        this.cacheFile = cacheFile;
        this.compareAgainstLastStableBuild = compareAgainstLastStableBuild;
    }

    public Run<?, ?> getRun() {
        return this.run;
    }

    public File getCacheFile() {
        return this.cacheFile;
    }

    public Boolean getCompareAgainstLastStableBuild() {
        return this.compareAgainstLastStableBuild;
    }

    public int getCurrentBuildNumber() {
        return this.run.getNumber();
    }

    public int getCompareBuildNumber() {
        Run previousCompletedBuild;
        if (this.compareAgainstLastStableBuild.booleanValue() && (previousCompletedBuild = this.run.getPreviousCompletedBuild()) != null) {
            return previousCompletedBuild.getNumber();
        }
        Run previousBuild = this.run.getPreviousBuild();
        if (Objects.isNull(previousBuild)) {
            return this.getCurrentBuildNumber();
        }
        return previousBuild.getNumber();
    }

    public List<DiffRow> getDiffLines() {
        File comparingFile = this.compareAgainstLastStableBuild != false ? this.getLastStableBuildFile() : this.getPreviousBuildFile();
        if (comparingFile == null) {
            return new ArrayList<DiffRow>();
        }
        List<LineOutput> currentBuildLines = this.getAllCacheFromFile();
        List<LineOutput> currentBuildLinesToDisplay = currentBuildLines.stream().filter(LineOutput::getDisplay).collect(Collectors.toList());
        List<LineOutput> previousBuildLines = this.getAllCacheFromNamedFile(comparingFile);
        List<LineOutput> previousBuildLinesToDisplay = previousBuildLines.stream().filter(LineOutput::getDisplay).collect(Collectors.toList());
        List<String> current = this.extractStringFromLogFlowOutput(currentBuildLinesToDisplay);
        List<String> previous = this.extractStringFromLogFlowOutput(previousBuildLinesToDisplay);
        DiffRowGenerator generator = DiffRowGenerator.create().showInlineDiffs(true).inlineDiffByWord(true).oldTag(f -> "~").newTag(f -> "**").build();
        return generator.generateDiffRows(previous, current);
    }

    private List<String> extractStringFromLogFlowOutput(List<LineOutput> inputList) {
        ArrayList<String> result = new ArrayList<String>();
        for (LineOutput input : inputList) {
            result.add(input.getLine());
        }
        return result;
    }

    public List<LineOutput> getAllCacheFromFile() {
        return this.getAllCacheFromNamedFile(this.cacheFile);
    }

    private File getPreviousBuildFile() {
        Run previousBuild = this.getRun().getPreviousBuild();
        if (Objects.isNull(previousBuild)) {
            return null;
        }
        File buildFolder = previousBuild.getRootDir();
        return new File(buildFolder + File.separator + "LogFlowVisualizerCache.json");
    }

    private File getLastStableBuildFile() {
        Run previousLastStableBuild = this.getRun().getPreviousCompletedBuild();
        if (Objects.isNull(previousLastStableBuild)) {
            return null;
        }
        File buildFolder = previousLastStableBuild.getRootDir();
        return new File(buildFolder + File.separator + "LogFlowVisualizerCache.json");
    }

    private List<LineOutput> getAllCacheFromNamedFile(File file) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            return (List)objectMapper.readValue(file, (TypeReference)new TypeReference<List<LineOutput>>(){});
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Collection<? extends Action> getProjectActions() {
        return new ArrayList();
    }

    public String getIconFileName() {
        return "symbol-changes";
    }

    public String getDisplayName() {
        return "Log Flow Visualizer Diff";
    }

    public String getUrlName() {
        return "historyDiff";
    }
}

