/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.LogFlowVisualizer.actions;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import hudson.console.ConsoleNote;
import hudson.model.Action;
import hudson.model.Run;
import io.jenkins.plugins.LogFlowVisualizer.model.LineOutput;
import io.jenkins.plugins.LogFlowVisualizer.model.LineType;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import jenkins.tasks.SimpleBuildStep;

public class LogFlowHTMLAction
implements SimpleBuildStep.LastBuildAction {
    private final Run<?, ?> run;
    private final File cacheFile;

    public LogFlowHTMLAction(Run<?, ?> run, File cacheFile) {
        this.run = run;
        this.cacheFile = cacheFile;
    }

    public List<String> getLogs() throws IOException {
        Reader reader = this.run.getLogReader();
        BufferedReader bufferedReader = new BufferedReader(reader);
        ArrayList<String> result = new ArrayList<String>();
        String line = bufferedReader.readLine();
        while (line != null) {
            line = ConsoleNote.removeNotes((String)line);
            result.add(line);
            line = bufferedReader.readLine();
        }
        bufferedReader.close();
        return result;
    }

    public List<LineOutput> getMarkedLogs() throws IOException {
        List<String> fullLogs = this.getLogs();
        List<LineOutput> markedLogs = this.getAllCacheFromNamedFile(this.cacheFile);
        ArrayList<LineOutput> result = new ArrayList<LineOutput>();
        ListIterator<LineOutput> iteratorMarked = markedLogs.listIterator();
        LineOutput currentMarkedLine = null;
        if (iteratorMarked.hasNext()) {
            currentMarkedLine = iteratorMarked.next();
        }
        for (int index = 0; index < fullLogs.size(); ++index) {
            if (index == currentMarkedLine.getIndex()) {
                result.add(currentMarkedLine);
                if (!iteratorMarked.hasNext()) continue;
                currentMarkedLine = iteratorMarked.next();
                continue;
            }
            result.add(new LineOutput("", fullLogs.get(index), index, false, LineType.DEFAULT, 0L, false));
        }
        return result;
    }

    private List<LineOutput> getAllCacheFromNamedFile(File file) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            return (List)objectMapper.readValue(file, (TypeReference)new TypeReference<List<LineOutput>>(){});
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Collection<? extends Action> getProjectActions() {
        return new ArrayList();
    }

    public String getIconFileName() {
        return "symbol-logs";
    }

    public String getDisplayName() {
        return "Log Flow Visualizer HTML Logs";
    }

    public String getUrlName() {
        return "html";
    }
}

