/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.LogFlowVisualizer;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.DescriptorExtensionList;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.console.ConsoleNote;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import io.jenkins.plugins.LogFlowVisualizer.LogFlowFilter;
import io.jenkins.plugins.LogFlowVisualizer.LogFlowPictureMaker;
import io.jenkins.plugins.LogFlowVisualizer.actions.LogFlowHTMLAction;
import io.jenkins.plugins.LogFlowVisualizer.actions.LogFlowHistoryDiffAction;
import io.jenkins.plugins.LogFlowVisualizer.actions.LogFlowOffsetAction;
import io.jenkins.plugins.LogFlowVisualizer.actions.LogFlowProjectAction;
import io.jenkins.plugins.LogFlowVisualizer.input.LogFlowInput;
import io.jenkins.plugins.LogFlowVisualizer.input.LogFlowInputDescriptor;
import io.jenkins.plugins.LogFlowVisualizer.model.LineOutput;
import io.jenkins.plugins.LogFlowVisualizer.model.LineWithOffset;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.imageio.ImageIO;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

@Extension
public class LogFlowRecorder
extends Recorder
implements SimpleBuildStep {
    public static final String cacheName = "LogFlowVisualizerCache.json";
    public static final String cachePictureName = "LogFlowVisualizerResult.png";
    private List<LogFlowInput> configurations;
    private Boolean generatePicture = false;
    private Boolean compareAgainstLastStableBuild = false;
    int DEFAULT_IMAGE_WIDTH = 1200;
    int DEFAULT_IMAGE_HEIGHT = 800;

    public LogFlowRecorder() {
    }

    @DataBoundConstructor
    public LogFlowRecorder(List<LogFlowInput> configurations, Boolean generatePicture, Boolean compareAgainstLastStableBuild) {
        this.configurations = configurations;
        this.generatePicture = generatePicture;
        this.compareAgainstLastStableBuild = compareAgainstLastStableBuild;
    }

    public Boolean getCompareAgainstLastStableBuild() {
        return this.compareAgainstLastStableBuild;
    }

    @DataBoundSetter
    public void setCompareAgainstLastStableBuild(Boolean compareAgainstLastStableBuild) {
        this.compareAgainstLastStableBuild = compareAgainstLastStableBuild;
    }

    public Boolean getGeneratePicture() {
        return this.generatePicture;
    }

    @DataBoundSetter
    public void setGeneratePicture(Boolean generatePicture) {
        this.generatePicture = generatePicture;
    }

    public List<LogFlowInput> getConfigurations() {
        return this.configurations;
    }

    public void setConfigurations(List<LogFlowInput> configurations) {
        this.configurations = configurations;
    }

    public DescriptorExtensionList<LogFlowInput, LogFlowInputDescriptor> getFormatDescriptors() {
        return Jenkins.get().getDescriptorList(LogFlowInput.class);
    }

    public void perform(@NonNull Run<?, ?> run, @NonNull FilePath workspace, @NonNull EnvVars env, @NonNull Launcher launcher, @NonNull TaskListener listener) throws IOException {
        if (Objects.isNull(this.configurations) || this.configurations.isEmpty()) {
            listener.getLogger().println("LFV: configurations are empty");
            return;
        }
        File rootDir = run.getRootDir();
        File currentBuildFolder = new File(rootDir.getPath());
        File defaultLogs = new File(currentBuildFolder + File.separator + "log");
        boolean mkdirsResult = currentBuildFolder.mkdirs();
        if (mkdirsResult) {
            listener.getLogger().println("LFV: Created new directories");
        }
        RandomAccessFile raf = new RandomAccessFile(defaultLogs, "r");
        ArrayList<LineWithOffset> logLines = new ArrayList<LineWithOffset>();
        long currentOffset = raf.getFilePointer();
        String line = raf.readLine();
        while (line != null) {
            line = ConsoleNote.removeNotes((String)line);
            logLines.add(new LineWithOffset(line, currentOffset));
            currentOffset = raf.getFilePointer();
            line = raf.readLine();
        }
        raf.close();
        List<LineOutput> filterOutput = LogFlowFilter.filter(logLines, this.getConfigurations());
        File jsonCacheFile = new File(currentBuildFolder.getPath() + File.separator + cacheName);
        boolean createFileResult = jsonCacheFile.createNewFile();
        if (!createFileResult) {
            listener.getLogger().println("LFV: LogFlowVisualizerCache.json was not created");
            return;
        }
        LogFlowFilter.saveToJSON(filterOutput, jsonCacheFile);
        if (this.generatePicture.booleanValue() && this.createPicture(listener, filterOutput, currentBuildFolder)) {
            return;
        }
        LogFlowProjectAction action = new LogFlowProjectAction(run, this.getConfigurations(), jsonCacheFile, this.compareAgainstLastStableBuild);
        run.addAction((Action)action);
        run.addAction((Action)new LogFlowHTMLAction(run, jsonCacheFile));
        run.addAction((Action)new LogFlowOffsetAction(run));
        run.addAction((Action)new LogFlowHistoryDiffAction(run, jsonCacheFile, this.compareAgainstLastStableBuild));
    }

    private boolean createPicture(TaskListener listener, List<LineOutput> filterOutput, File currentBuildFolder) throws IOException {
        int width = this.DEFAULT_IMAGE_WIDTH;
        int height = this.DEFAULT_IMAGE_HEIGHT;
        LogFlowPictureMaker pm = new LogFlowPictureMaker(width, height);
        BufferedImage image = pm.createPicture(filterOutput);
        File picturePath = new File(currentBuildFolder + File.separator + "archive" + File.separator + cachePictureName);
        boolean pictureMkdirResult = picturePath.mkdirs();
        if (!pictureMkdirResult) {
            listener.getLogger().println("LFV: cache directories for picture were not successfully created");
            return true;
        }
        ImageIO.write((RenderedImage)image, "png", picturePath);
        return false;
    }

    @Symbol(value={"logFlowVisualizer"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        @NonNull
        public String getDisplayName() {
            return "Log Flow Visualizer";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }
}

