/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.LogFlowVisualizer;

import io.jenkins.plugins.LogFlowVisualizer.model.LineOutput;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.List;

public class LogFlowPictureMaker {
    private final int width;
    private int height;
    private Font font = new Font("Arial", 0, 20);
    private Color backColor = Color.WHITE;
    private Color textColor = Color.BLACK;

    public LogFlowPictureMaker(int width, int height, Font font, Color backColor, Color textColor) {
        this.width = width;
        this.height = height;
        this.font = font;
        this.backColor = backColor;
        this.textColor = textColor;
    }

    public LogFlowPictureMaker(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public Font getFont() {
        return this.font;
    }

    public Color getBackColor() {
        return this.backColor;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public BufferedImage createPicture(List<LineOutput> lines) {
        int toDisplayCounter = 0;
        for (LineOutput line : lines) {
            if (!line.getDisplay().booleanValue()) continue;
            ++toDisplayCounter;
        }
        this.setHeight((5 + toDisplayCounter) * this.font.getSize());
        BufferedImage image = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        Graphics2D graphics2D = image.createGraphics();
        graphics2D.setColor(this.getBackColor());
        graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics2D.setColor(this.getTextColor());
        graphics2D.setFont(this.getFont());
        int lineHeight = graphics2D.getFontMetrics().getHeight();
        int y = 25;
        for (LineOutput line : lines) {
            if (!line.getDisplay().booleanValue()) continue;
            graphics2D.setColor(this.getTextColor());
            switch (line.getType()) {
                case ONE_LINE: {
                    graphics2D.setColor(Color.green);
                    break;
                }
                case START_MARK: {
                    graphics2D.setColor(Color.darkGray);
                    break;
                }
                case END_MARK: {
                    graphics2D.setColor(Color.lightGray);
                    break;
                }
                case LIMIT_REACHED_LINE: {
                    graphics2D.setColor(Color.orange);
                    break;
                }
                case CONTENT_LINE: {
                    graphics2D.setColor(Color.blue);
                    break;
                }
                default: {
                    graphics2D.setColor(this.textColor);
                }
            }
            int x = 5;
            graphics2D.drawString(line.getIndex() + " " + line.getLine(), x, y);
            y += lineHeight;
        }
        return image;
    }
}

