/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.LogFlowVisualizer;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.jenkins.plugins.LogFlowVisualizer.input.LogFlowInput;
import io.jenkins.plugins.LogFlowVisualizer.input.LogFlowInputAdvanced;
import io.jenkins.plugins.LogFlowVisualizer.input.LogFlowInputSimple;
import io.jenkins.plugins.LogFlowVisualizer.model.LineOutput;
import io.jenkins.plugins.LogFlowVisualizer.model.LineType;
import io.jenkins.plugins.LogFlowVisualizer.model.LineWithOffset;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class LogFlowFilter {
    public static List<LineOutput> filter(List<LineWithOffset> lines, List<LogFlowInput> configs) {
        ArrayList<LineOutput> result = new ArrayList<LineOutput>();
        if (configs.isEmpty()) {
            return result;
        }
        int lineIndex = 0;
        int activeRegexCount = 0;
        boolean advancedRegexIsActive = false;
        LogFlowInputAdvanced activeConfig = null;
        for (LineWithOffset lineWithOffset : lines) {
            String line = lineWithOffset.getLine();
            if (advancedRegexIsActive) {
                boolean display;
                if (line.matches(activeConfig.getEndMark())) {
                    boolean display2;
                    boolean bl = display2 = activeConfig.getNumberOfLineToDisplay() == activeRegexCount + 1;
                    if (activeConfig.getDeleteMark().booleanValue()) {
                        String lineWithoutRegex = LogFlowFilter.removeRegexMark(line, activeConfig.getStartMark());
                        result.add(new LineOutput(activeConfig.getEndMark(), lineWithoutRegex, lineIndex, activeConfig.getDeleteMark(), LineType.END_MARK, lineWithOffset.getOffset(), display2));
                    } else {
                        result.add(new LineOutput(activeConfig.getEndMark(), line, lineIndex, activeConfig.getDeleteMark(), LineType.END_MARK, lineWithOffset.getOffset(), display2));
                    }
                    advancedRegexIsActive = false;
                    activeRegexCount = 0;
                    activeConfig = null;
                    ++lineIndex;
                    continue;
                }
                boolean bl = display = activeConfig.getNumberOfLineToDisplay() == activeRegexCount + 1;
                if (activeRegexCount >= activeConfig.getMaxContentLength()) {
                    result.add(new LineOutput(activeConfig.getStartMark(), line, lineIndex, activeConfig.getDeleteMark(), LineType.LIMIT_REACHED_LINE, lineWithOffset.getOffset(), display));
                    advancedRegexIsActive = false;
                    activeRegexCount = 0;
                    activeConfig = null;
                    ++lineIndex;
                    continue;
                }
                result.add(new LineOutput(activeConfig.getStartMark(), line, lineIndex, activeConfig.getDeleteMark(), LineType.CONTENT_LINE, lineWithOffset.getOffset(), display));
                ++activeRegexCount;
                ++lineIndex;
                continue;
            }
            for (LogFlowInput config : configs) {
                if (config instanceof LogFlowInputSimple) {
                    LogFlowInputSimple simpleConfig = (LogFlowInputSimple)config;
                    if (simpleConfig.getRegex().isEmpty() || !line.matches(simpleConfig.getRegex())) continue;
                    if (simpleConfig.getDeleteMark().booleanValue()) {
                        String lineWithoutRegex = LogFlowFilter.removeRegexMark(line, simpleConfig.getRegex());
                        result.add(new LineOutput(simpleConfig.getRegex(), lineWithoutRegex, lineIndex, simpleConfig.getDeleteMark(), LineType.ONE_LINE, lineWithOffset.getOffset(), true));
                        break;
                    }
                    result.add(new LineOutput(simpleConfig.getRegex(), line, lineIndex, simpleConfig.getDeleteMark(), LineType.ONE_LINE, lineWithOffset.getOffset(), true));
                    break;
                }
                if (config instanceof LogFlowInputAdvanced) {
                    boolean display;
                    LogFlowInputAdvanced advancedConfig = (LogFlowInputAdvanced)config;
                    if (advancedConfig.getStartMark().isEmpty() || advancedConfig.getEndMark().isEmpty() || !line.matches(advancedConfig.getStartMark())) continue;
                    boolean bl = display = advancedConfig.getNumberOfLineToDisplay() == 0;
                    if (advancedConfig.getDeleteMark().booleanValue()) {
                        String lineWithoutRegex = LogFlowFilter.removeRegexMark(line, advancedConfig.getStartMark());
                        result.add(new LineOutput(advancedConfig.getStartMark(), lineWithoutRegex, lineIndex, advancedConfig.getDeleteMark(), LineType.START_MARK, lineWithOffset.getOffset(), display));
                    } else {
                        result.add(new LineOutput(advancedConfig.getStartMark(), line, lineIndex, advancedConfig.getDeleteMark(), LineType.START_MARK, lineWithOffset.getOffset(), display));
                    }
                    activeConfig = advancedConfig;
                    advancedRegexIsActive = true;
                    break;
                }
                System.err.println("Unknown instance of config");
                return new ArrayList<LineOutput>();
            }
            ++lineIndex;
        }
        return result;
    }

    public static void saveToJSON(List<LineOutput> list, File file) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            objectMapper.writeValue(file, list);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String removeRegexMark(String line, String regex) {
        return line.replaceAll(regex, "");
    }
}

