/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.localization.support.stapler;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.ExtensionList;
import hudson.ExtensionListListener;
import hudson.init.Initializer;
import io.jenkins.plugins.localization.support.LocalizationContributor;
import io.jenkins.plugins.localization.support.stapler.ResourceBundleFactoryImpl;
import jakarta.servlet.ServletContext;
import java.net.URL;
import java.net.URLClassLoader;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.MetaClassLoader;
import org.kohsuke.stapler.WebApp;
import org.kohsuke.stapler.jelly.JellyFacet;

@Restricted(value={NoExternalUse.class})
public class StaplerManager
extends ExtensionListListener {
    @Initializer
    public static void initialize() {
        WebApp webApp = WebApp.get((ServletContext)Jenkins.get().getServletContext());
        JellyFacet facet = (JellyFacet)webApp.getFacet(JellyFacet.class);
        facet.resourceBundleFactory = new ResourceBundleFactoryImpl();
        ExtensionList.lookup(LocalizationContributor.class).addListener((ExtensionListListener)new StaplerManager());
        MetaClassLoader.debugLoader = StaplerManager.buildMetaClassLoader();
    }

    private static MetaClassLoader buildMetaClassLoader() {
        return new MetaClassLoader((ClassLoader)new URLClassLoader((URL[])ExtensionList.lookup(LocalizationContributor.class).stream().map(c -> c.getClass().getProtectionDomain().getCodeSource().getLocation()).toArray(URL[]::new)));
    }

    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
    public void onChange() {
        MetaClassLoader.debugLoader = StaplerManager.buildMetaClassLoader();
    }
}

