/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.localization.support.stapler;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.PluginWrapper;
import io.jenkins.plugins.localization.support.LocalizationContributor;
import java.net.URL;
import java.util.logging.Logger;
import jenkins.PluginLocaleDrivenResourceProvider;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension
@Restricted(value={NoExternalUse.class})
public class PluginLocaleDrivenResourceProviderImpl
implements PluginLocaleDrivenResourceProvider {
    private static final Logger LOGGER = Logger.getLogger(PluginLocaleDrivenResourceProviderImpl.class.getName());

    public URL lookup(@NonNull String path) {
        PluginWrapper pluginWrapper = this.findPluginForResourceUrl(path);
        if (pluginWrapper != null) {
            path = path.substring(pluginWrapper.baseResourceURL.toString().length());
            LOGGER.fine("Looking up localized file '" + path + "' from plugin '" + String.valueOf(pluginWrapper) + "'");
        } else {
            LOGGER.fine("Looking up localized file '" + path + "' from webapp");
        }
        for (LocalizationContributor contributor : ExtensionList.lookup(LocalizationContributor.class)) {
            URL url = pluginWrapper == null ? contributor.getResource(path) : contributor.getPluginResource(path, pluginWrapper);
            if (url == null) continue;
            LOGGER.fine("Found localized file '" + path + "'");
            return url;
        }
        LOGGER.fine("Failed to find localized file '" + path + "'");
        return null;
    }

    private PluginWrapper findPluginForResourceUrl(String s) {
        for (PluginWrapper wrapper : Jenkins.get().pluginManager.getPlugins()) {
            if (!s.startsWith(wrapper.baseResourceURL.toString())) continue;
            return wrapper;
        }
        return null;
    }
}

