/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.localization.support;

import hudson.Extension;
import hudson.PluginWrapper;
import hudson.model.AdministrativeMonitor;
import hudson.util.HttpResponses;
import io.jenkins.plugins.localization.support.Messages;
import io.jenkins.plugins.localization.support.stapler.ResourceBundleFactoryImpl;
import jakarta.servlet.ServletContext;
import java.io.IOException;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.WebApp;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.kohsuke.stapler.jelly.JellyFacet;
import org.kohsuke.stapler.jelly.ResourceBundleFactory;

@Extension
@Symbol(value={"localizationMonitor"})
@Restricted(value={NoExternalUse.class})
public class LocalizationMonitor
extends AdministrativeMonitor {
    private PluginWrapper plugin;

    public String getDisplayName() {
        return Messages.LocalizationMonitor_DisplayName();
    }

    public boolean isActivated() {
        Jenkins jenkins = Jenkins.get();
        WebApp webContext = WebApp.get((ServletContext)jenkins.getServletContext());
        JellyFacet facet = (JellyFacet)webContext.getFacet(JellyFacet.class);
        ResourceBundleFactory factory = facet.resourceBundleFactory;
        Class<?> factoryClazz = factory.getClass();
        this.plugin = jenkins.getPluginManager().whichPlugin(factoryClazz);
        return !(factory instanceof ResourceBundleFactoryImpl);
    }

    @RequirePOST
    @Restricted(value={NoExternalUse.class})
    public HttpResponse doAct(StaplerRequest2 req) throws IOException {
        if (req.hasParameter("no")) {
            this.disable(true);
            return HttpResponses.redirectViaContextPath((String)"/manage");
        }
        return HttpResponses.redirectViaContextPath((String)"/pluginManager/installed");
    }

    @Restricted(value={NoExternalUse.class})
    public PluginWrapper getPlugin() {
        return this.plugin;
    }
}

