/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.localization.support;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.PluginWrapper;
import java.net.URL;
import jenkins.model.Jenkins;

public abstract class LocalizationContributor
implements ExtensionPoint {
    @CheckForNull
    public abstract URL getResource(@NonNull String var1);

    @NonNull
    public String getName() {
        return this.getClass().getName();
    }

    @CheckForNull
    public final String getPluginName() {
        PluginWrapper plugin;
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        if (jenkins != null && (plugin = jenkins.pluginManager.whichPlugin(this.getClass())) != null) {
            return plugin.getShortName();
        }
        return null;
    }

    public static URL findResource(String resource, Class clazz) {
        Object resourceName = resource.startsWith("/") ? resource.substring(1) : clazz.getPackage().getName().replace('.', '/') + "/" + resource;
        for (LocalizationContributor contributor : ExtensionList.lookup(LocalizationContributor.class)) {
            URL url = contributor.getResource((String)resourceName);
            if (url == null) continue;
            return url;
        }
        return clazz.getResource(resource);
    }

    @CheckForNull
    public abstract URL getPluginResource(@NonNull String var1, @NonNull PluginWrapper var2);
}

