/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.llvm;

import io.jenkins.plugins.coverage.adapter.parser.CoverageParser;
import io.jenkins.plugins.coverage.targets.CoverageElement;
import io.jenkins.plugins.coverage.targets.CoverageResult;
import io.jenkins.plugins.coverage.targets.Ratio;
import org.w3c.dom.Element;

public class LLVMCoverageParser
extends CoverageParser {
    public LLVMCoverageParser(String reportName) {
        super(reportName);
    }

    protected CoverageResult processElement(Element current, CoverageResult parentResult) {
        CoverageResult result = null;
        String name = current.getLocalName();
        if (name == null) {
            name = current.getTagName();
        }
        switch (name) {
            case "report": {
                result = new CoverageResult(CoverageElement.REPORT, null, this.getAttribute(current, "name", "") + ": " + this.getReportName());
                break;
            }
            case "data": {
                result = new CoverageResult(CoverageElement.get((String)"LLVM Data"), parentResult, this.getAttribute(current, "name", ""));
                break;
            }
            case "directory": {
                result = new CoverageResult(CoverageElement.get((String)"LLVM Directory"), parentResult, this.getAttribute(current, "name", ""));
                break;
            }
            case "file": {
                result = new CoverageResult(CoverageElement.get((String)"LLVM File"), parentResult, this.getAttribute(current, "filename", ""));
                result.setRelativeSourcePath(this.getAttribute(current, "filename", null));
                String coveredLineStr = this.getAttribute(current, "line-covered", "0");
                String totalLineStr = this.getAttribute(current, "line-total", coveredLineStr);
                result.updateCoverage(CoverageElement.LINE, Ratio.create((float)Integer.parseInt(coveredLineStr), (float)Integer.parseInt(totalLineStr)));
                String coveredFuncStr = this.getAttribute(current, "func-covered", "0");
                String totalFuncStr = this.getAttribute(current, "func-total", coveredFuncStr);
                result.updateCoverage(CoverageElement.get((String)"LLVM Function"), Ratio.create((float)Integer.parseInt(coveredFuncStr), (float)Integer.parseInt(totalFuncStr)));
                break;
            }
            case "line": {
                String hitsString = current.getAttribute("hits");
                String lineNumber = current.getAttribute("number");
                int hits = Integer.parseInt(hitsString);
                int number = Integer.parseInt(lineNumber);
                parentResult.paint(number, hits);
                break;
            }
        }
        return result;
    }
}

