/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.llvm;

import com.fasterxml.jackson.databind.JsonNode;
import io.jenkins.plugins.coverage.adapter.converter.JSONDocumentConverter;
import io.jenkins.plugins.coverage.exception.CoverageException;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LLVMCovReportDocumentConverter
extends JSONDocumentConverter {
    protected Document convert(JsonNode report, Document document) throws CoverageException {
        if (!report.get("version").asText().equals("2.0.0")) {
            throw new CoverageException("Unsupported Json file - version must be 2.0.0");
        }
        if (!report.get("type").asText().equals("llvm.coverage.json.export")) {
            throw new CoverageException("Unsupported Json file - type must be llvm.coverage.json.export");
        }
        Element reportEle = document.createElement("report");
        reportEle.setAttribute("name", "llvm-cov");
        document.appendChild(reportEle);
        JsonNode dataArr = report.get("data");
        if (dataArr == null || dataArr.size() == 0) {
            throw new CoverageException("No data section found in coverage report, will skip it");
        }
        if (dataArr.size() == 1) {
            Element dataEle = document.createElement("data");
            dataEle.setAttribute("name", "data");
            reportEle.appendChild(dataEle);
            JsonNode dataObj = dataArr.get(0);
            this.processDataObj(dataObj, dataEle, document);
        } else {
            for (int i = 0; i < dataArr.size(); ++i) {
                Element dataEle = document.createElement("data");
                dataEle.setAttribute("name", "data" + i);
                reportEle.appendChild(dataEle);
                JsonNode dataObj = dataArr.get(i);
                this.processDataObj(dataObj, dataEle, document);
            }
        }
        return document;
    }

    private void processDataObj(JsonNode dataObj, Element dataEle, Document document) throws CoverageException {
        JsonNode files = dataObj.get("files");
        JsonNode functions = dataObj.get("functions");
        List<Element> fileElements = this.processFiles(files, document);
        fileElements.stream().collect(Collectors.groupingBy(f -> {
            String filename = f.getAttribute("filename");
            File path = new File(filename);
            if (StringUtils.isEmpty((String)path.getParent())) {
                return ".";
            }
            return path.getParent();
        })).forEach((parentPath, fileEles) -> {
            Element directoryEle = document.createElement("directory");
            directoryEle.setAttribute("name", (String)parentPath);
            fileEles.forEach(directoryEle::appendChild);
            dataEle.appendChild(directoryEle);
        });
        this.processFunctions(functions, fileElements, document);
    }

    private List<Element> processFiles(JsonNode files, Document document) throws CoverageException {
        LinkedList<Element> fileElements = new LinkedList<Element>();
        for (int i = 0; i < files.size(); ++i) {
            JsonNode file = files.get(i);
            Element fileEle = document.createElement("file");
            fileEle.setAttribute("filename", file.get("filename").asText());
            JsonNode segments = file.get("segments");
            this.processLines(segments, fileEle, document);
            fileElements.add(fileEle);
            fileEle.setAttribute("line-covered", file.get("summary").get("lines").get("covered").asText());
            fileEle.setAttribute("line-total", file.get("summary").get("lines").get("count").asText());
            fileEle.setAttribute("func-covered", file.get("summary").get("functions").get("covered").asText());
            fileEle.setAttribute("func-total", file.get("summary").get("functions").get("count").asText());
        }
        return fileElements;
    }

    private void processFunctions(JsonNode functions, List<Element> fileElements, Document document) {
        for (int i = 0; i < functions.size(); ++i) {
            Element functionEle = document.createElement("function");
            JsonNode function = functions.get(i);
            String name = function.get("name").asText();
            JsonNode regions = function.get("regions");
            JsonNode filenames = function.get("filenames");
            functionEle.setAttribute("name", name);
            for (int j = 0; j < filenames.size(); ++j) {
                String filename = filenames.get(j).asText();
                Optional<Element> correspondFileOptional = fileElements.stream().filter(f -> f.getAttribute("filename").equals(filename)).findAny();
                if (!correspondFileOptional.isPresent()) continue;
                Element correspondFile = correspondFileOptional.get();
                correspondFile.appendChild(functionEle);
                StreamSupport.stream(Spliterators.spliteratorUnknownSize(regions.iterator(), 16), false).forEach(r -> {
                    NodeList lines = correspondFile.getElementsByTagName("line");
                    for (int k = 0; k < lines.getLength(); ++k) {
                        Element lineEleInFile = (Element)lines.item(k);
                        int line = Integer.parseInt(lineEleInFile.getAttribute("number"));
                        if (line < r.get(0).asInt() || line > r.get(2).asInt()) continue;
                        Node n = lineEleInFile.cloneNode(true);
                        functionEle.appendChild(n);
                        break;
                    }
                });
            }
        }
    }

    private void processLines(JsonNode segmentsNode, Element fileEle, Document document) throws CoverageException {
        List segments = StreamSupport.stream(Spliterators.spliteratorUnknownSize(segmentsNode.iterator(), 16), false).collect(Collectors.toList());
        if (segments.size() == 0) {
            return;
        }
        if (segments.size() == 1) {
            JsonNode seg = (JsonNode)segments.get(0);
            if (!this.isSegmentHasCount(seg)) {
                return;
            }
            int lineNumber = seg.get(0).asInt();
            int count = seg.get(2).asInt();
            this.appendLine(fileEle, document, lineNumber, count);
            return;
        }
        LinkedHashMap segmentsWithLineNum = segments.stream().collect(Collectors.groupingBy(s -> s.get(0).asInt(), LinkedHashMap::new, Collectors.toList()));
        Iterator lineIterator = segmentsWithLineNum.entrySet().iterator();
        Map.Entry previousLine = lineIterator.next();
        this.processLine(fileEle, document, (Integer)previousLine.getKey(), (List)previousLine.getValue());
        while (lineIterator.hasNext()) {
            Map.Entry currentLine = lineIterator.next();
            int previousLineNum = (Integer)previousLine.getKey();
            int currentLineNum = (Integer)currentLine.getKey();
            if (currentLineNum < previousLineNum) {
                throw new CoverageException(String.format("Not a valid segment sequences in file %s", fileEle.getAttribute("filename")));
            }
            if ((Integer)currentLine.getKey() - (Integer)previousLine.getKey() == 1) {
                this.processLine(fileEle, document, (Integer)currentLine.getKey(), (List)currentLine.getValue());
                previousLine = currentLine;
                continue;
            }
            JsonNode lastSegment = (JsonNode)((List)previousLine.getValue()).get(((List)previousLine.getValue()).size() - 1);
            if (!this.isSegmentHasCount(lastSegment)) {
                previousLine = currentLine;
                continue;
            }
            int count = lastSegment.get(2).asInt();
            while (++previousLineNum < currentLineNum) {
                this.appendLine(fileEle, document, previousLineNum, count);
            }
            previousLine = currentLine;
        }
    }

    private void processLine(Element parent, Document document, int lineNum, List<JsonNode> segs) {
        int maxHits = 0;
        for (JsonNode s : segs) {
            int hasCount = s.get(3).asInt();
            if (hasCount == 0) {
                return;
            }
            int hits = s.get(2).asInt();
            maxHits = Math.max(hits, maxHits);
        }
        this.appendLine(parent, document, lineNum, maxHits);
    }

    private void appendLine(Element parent, Document document, int number, int hits) {
        Element lineEle = document.createElement("line");
        lineEle.setAttribute("number", Integer.toString(number));
        lineEle.setAttribute("hits", Integer.toString(hits));
        parent.appendChild(lineEle);
    }

    private boolean isSegmentHasCount(JsonNode segment) {
        return segment.get(3).asInt() == 1;
    }
}

