/*
 * Decompiled with CFR 0.152.
 */
package org.aerogear.kryptowire;

import hudson.model.Run;
import java.io.File;
import java.io.IOException;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import jenkins.model.RunAction2;
import org.aerogear.kryptowire.BinaryInfo;
import org.aerogear.kryptowire.BinaryStatus;
import org.aerogear.kryptowire.GlobalConfigurationImpl;
import org.aerogear.kryptowire.KryptowireServiceImpl;
import org.json.JSONObject;

public class BinaryHistoryAction
implements RunAction2 {
    private BinaryInfo info;
    private transient Run run;
    private BinaryStatus status;
    private transient GlobalConfigurationImpl cfg;

    public BinaryHistoryAction(BinaryInfo info) {
        this.info = info;
    }

    public void onAttached(Run<?, ?> run) {
        this.run = run;
    }

    public void onLoad(Run<?, ?> run) {
        this.run = run;
    }

    public String getIconFileName() {
        return "/plugin/aerogear-kryptowire-plugin/menu-logo.png";
    }

    public String getDisplayName() {
        return "Kryptowire Scan Results";
    }

    public String getUrlName() {
        return "kryptowire";
    }

    public BinaryInfo getInfo() {
        return this.info;
    }

    public void setInfo(BinaryInfo info) {
        this.info = info;
    }

    public Run getRun() {
        return this.run;
    }

    public void setRun(Run run) {
        this.run = run;
    }

    public void setStatus(BinaryStatus status) {
        this.status = status;
    }

    public BinaryStatus getStatus() throws IOException, InterruptedException {
        if (this.status != null) {
            return this.status;
        }
        GlobalConfigurationImpl cfg = this.getCfg();
        KryptowireServiceImpl kws = new KryptowireServiceImpl(cfg.getKwEndpoint(), cfg.getKwApiKey());
        if (!kws.isCompleted(this.info.getHash())) {
            return BinaryStatus.notReady();
        }
        JSONObject out = kws.getResult(this.info.getUuid());
        if (out.isNull("threat_score")) {
            return BinaryStatus.notReady();
        }
        this.status = BinaryStatus.fromJSONObject(out);
        File targetFile = new File(String.valueOf(this.getRun().getArtifactsDir()) + "/kryptowire.pdf");
        if (!targetFile.exists()) {
            kws.downloadReport(this.info.getHash(), "pdf", targetFile);
        }
        if (!(targetFile = new File(String.valueOf(this.getRun().getArtifactsDir()) + "/kryptowire-niap.pdf")).exists()) {
            kws.downloadReport(this.info.getHash(), "niap_pdf", targetFile);
        }
        this.getRun().save();
        return this.status;
    }

    public String getExternalLink() {
        GlobalConfigurationImpl cfg = this.getCfg();
        return cfg.getKwEndpoint() + "/#/" + this.info.getPlatform() + "-report/" + this.info.getUuid();
    }

    private GlobalConfigurationImpl getCfg() {
        if (this.cfg == null) {
            this.cfg = (GlobalConfigurationImpl)((Object)GlobalConfiguration.all().get(GlobalConfigurationImpl.class));
        }
        return this.cfg;
    }

    public String getReportPath() {
        return this.getArchivePath("kryptowire.pdf");
    }

    public String getNIAPReportPath() {
        return this.getArchivePath("kryptowire-niap.pdf");
    }

    private String getArchivePath(String path) {
        String rootUrl = Jenkins.getActiveInstance().getRootUrl();
        return rootUrl + this.getRun().getUrl() + "artifact/" + path;
    }
}

