/*
 * Decompiled with CFR 0.152.
 */
package com.github.cyanbaz.jenkins.plugins.jsonparameter;

import com.github.cyanbaz.jenkins.plugins.jsonparameter.JsonResult;
import com.github.cyanbaz.jenkins.plugins.jsonparameter.Messages;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import hudson.ExtensionPoint;
import hudson.model.AbstractDescribableImpl;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;

public abstract class JsonSource
extends AbstractDescribableImpl<JsonSource>
implements ExtensionPoint,
Serializable {
    private static final long serialVersionUID = 1L;

    public abstract String loadJson() throws IOException, InterruptedException;

    public JsonResult<ListBoxModel> loadOptions(String query) {
        ListBoxModel model = new ListBoxModel();
        try {
            String json = this.loadJson();
            List values = (List)JsonPath.read((String)json, (String)query, (Predicate[])new Predicate[0]);
            if (values.isEmpty()) {
                return JsonResult.failure(Messages.error_no_data());
            }
            for (String value : values) {
                model.add(value, value);
            }
        }
        catch (Exception e) {
            return JsonResult.failure(e.getMessage());
        }
        return JsonResult.success(model);
    }
}

