// CHECKSTYLE:OFF

package com.github.cyanbaz.jenkins.plugins.jsonparameter;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code error.jenkins_item_not_found}: {@code No Jenkins item found
     * in the current request context.}.
     * 
     * @return
     *     {@code No Jenkins item found in the current request context.}
     */
    public static String error_jenkins_item_not_found() {
        return holder.format("error.jenkins_item_not_found");
    }

    /**
     * Key {@code error.jenkins_item_not_found}: {@code No Jenkins item found
     * in the current request context.}.
     * 
     * @return
     *     {@code No Jenkins item found in the current request context.}
     */
    public static Localizable _error_jenkins_item_not_found() {
        return new Localizable(holder, "error.jenkins_item_not_found");
    }

    /**
     * Key {@code error.config_id_not_found}: {@code The selected config ID
     * "{0}" does not exist.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The selected config ID "{0}" does not exist.}
     */
    public static String error_config_id_not_found(Object arg0) {
        return holder.format("error.config_id_not_found", arg0);
    }

    /**
     * Key {@code error.config_id_not_found}: {@code The selected config ID
     * "{0}" does not exist.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The selected config ID "{0}" does not exist.}
     */
    public static Localizable _error_config_id_not_found(Object arg0) {
        return new Localizable(holder, "error.config_id_not_found", arg0);
    }

    /**
     * Key {@code error.unsupported_credential_type}: {@code Unsupported
     * credential type: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unsupported credential type: {0}}
     */
    public static String error_unsupported_credential_type(Object arg0) {
        return holder.format("error.unsupported_credential_type", arg0);
    }

    /**
     * Key {@code error.unsupported_credential_type}: {@code Unsupported
     * credential type: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unsupported credential type: {0}}
     */
    public static Localizable _error_unsupported_credential_type(Object arg0) {
        return new Localizable(holder, "error.unsupported_credential_type", arg0);
    }

    /**
     * Key {@code placeholder.config_file_id}: {@code -- Select --}.
     * 
     * @return
     *     {@code -- Select --}
     */
    public static String placeholder_config_file_id() {
        return holder.format("placeholder.config_file_id");
    }

    /**
     * Key {@code placeholder.config_file_id}: {@code -- Select --}.
     * 
     * @return
     *     {@code -- Select --}
     */
    public static Localizable _placeholder_config_file_id() {
        return new Localizable(holder, "placeholder.config_file_id");
    }

    /**
     * Key {@code error.http_request_failed}: {@code Failed to fetch JSON
     * from URL "{0}" using credentials "{1}": HTTP {2} - {3}}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, as {@link String#valueOf(Object)}.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to fetch JSON from URL "{0}" using credentials "{1}":
     *     HTTP {2} - {3}}
     */
    public static String error_http_request_failed(Object arg0, Object arg1, Object arg2, Object arg3) {
        return holder.format("error.http_request_failed", arg0, arg1, arg2, arg3);
    }

    /**
     * Key {@code error.http_request_failed}: {@code Failed to fetch JSON
     * from URL "{0}" using credentials "{1}": HTTP {2} - {3}}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, as {@link String#valueOf(Object)}.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to fetch JSON from URL "{0}" using credentials "{1}":
     *     HTTP {2} - {3}}
     */
    public static Localizable _error_http_request_failed(Object arg0, Object arg1, Object arg2, Object arg3) {
        return new Localizable(holder, "error.http_request_failed", arg0, arg1, arg2, arg3);
    }

    /**
     * Key {@code placeholder.select_option}: {@code -- Choose an option --}.
     * 
     * @return
     *     {@code -- Choose an option --}
     */
    public static String placeholder_select_option() {
        return holder.format("placeholder.select_option");
    }

    /**
     * Key {@code placeholder.select_option}: {@code -- Choose an option --}.
     * 
     * @return
     *     {@code -- Choose an option --}
     */
    public static Localizable _placeholder_select_option() {
        return new Localizable(holder, "placeholder.select_option");
    }

    /**
     * Key {@code error.no_data}: {@code No data found. Check your JSON
     * source or query.}.
     * 
     * @return
     *     {@code No data found. Check your JSON source or query.}
     */
    public static String error_no_data() {
        return holder.format("error.no_data");
    }

    /**
     * Key {@code error.no_data}: {@code No data found. Check your JSON
     * source or query.}.
     * 
     * @return
     *     {@code No data found. Check your JSON source or query.}
     */
    public static Localizable _error_no_data() {
        return new Localizable(holder, "error.no_data");
    }

    /**
     * Key {@code error.empty_username}: {@code Empty username in
     * Username/Password credentials. If you need to use a bearer token,
     * configure Secret Text credentials instead.}.
     * 
     * @return
     *     {@code Empty username in Username/Password credentials. If you need to
     *     use a bearer token, configure Secret Text credentials instead.}
     */
    public static String error_empty_username() {
        return holder.format("error.empty_username");
    }

    /**
     * Key {@code error.empty_username}: {@code Empty username in
     * Username/Password credentials. If you need to use a bearer token,
     * configure Secret Text credentials instead.}.
     * 
     * @return
     *     {@code Empty username in Username/Password credentials. If you need to
     *     use a bearer token, configure Secret Text credentials instead.}
     */
    public static Localizable _error_empty_username() {
        return new Localizable(holder, "error.empty_username");
    }

}
