/*
 * Decompiled with CFR 0.152.
 */
package com.github.cyanbaz.jenkins.plugins.jsonparameter;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.github.cyanbaz.jenkins.plugins.jsonparameter.JsonSource;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ProxyConfiguration;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.queue.Tasks;
import hudson.security.ACL;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.verb.POST;
import org.springframework.security.core.Authentication;

public class RemoteSource
extends JsonSource {
    private final String url;
    private final String credentialsId;

    @DataBoundConstructor
    public RemoteSource(String url, String credentialsId) {
        this.url = url;
        this.credentialsId = credentialsId;
    }

    public String getUrl() {
        return this.url;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    @Override
    public String loadJson() throws IOException, InterruptedException {
        HttpRequest.Builder builder = HttpRequest.newBuilder().uri(URI.create(this.url)).header("Accept", "application/json").GET();
        if (this.credentialsId != null && !this.credentialsId.isEmpty()) {
            Credentials credentials = this.resolveCredentials();
            if (credentials == null) {
                throw new IllegalArgumentException("Credentials not found: " + this.credentialsId);
            }
            String authHeader = this.buildAuthorizationHeader(credentials);
            builder.header("Authorization", authHeader);
        }
        return this.executeRequest(builder.build());
    }

    private Credentials resolveCredentials() {
        Job job = (Job)Stapler.getCurrentRequest2().findAncestorObject(Job.class);
        if (job == null) {
            throw new IllegalStateException("No job context found");
        }
        return CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentialsInItem(Credentials.class, (Item)job, (Authentication)ACL.SYSTEM2, (List)URIRequirementBuilder.fromUri((String)this.url).build()), (CredentialsMatcher)CredentialsMatchers.withId((String)this.credentialsId));
    }

    private String buildAuthorizationHeader(Credentials credentials) {
        if (credentials instanceof StandardUsernamePasswordCredentials) {
            StandardUsernamePasswordCredentials userPass = (StandardUsernamePasswordCredentials)credentials;
            String user = userPass.getUsername();
            String pass = userPass.getPassword().getPlainText();
            return !user.isEmpty() ? "Basic " + Base64.getEncoder().encodeToString((user + ":" + pass).getBytes(StandardCharsets.UTF_8)) : "Bearer " + pass;
        }
        if (credentials instanceof StringCredentials) {
            StringCredentials token = (StringCredentials)credentials;
            String secret = token.getSecret().getPlainText();
            return "Bearer " + secret;
        }
        throw new IllegalArgumentException("Unsupported credentials type: " + credentials.getClass().getName());
    }

    private String executeRequest(HttpRequest request) throws IOException, InterruptedException {
        HttpClient client = ProxyConfiguration.newHttpClient();
        HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
        int status = response.statusCode();
        if (status >= 400) {
            throw new IOException("Failed to fetch JSON from URL '" + this.url + "' using credentials '" + this.credentialsId + "': HTTP " + status + " - " + response.body());
        }
        return response.body();
    }

    @Extension
    @Symbol(value={"remoteSource"})
    public static class DescriptorImpl
    extends Descriptor<JsonSource> {
        @NonNull
        public String getDisplayName() {
            return "Remote";
        }

        @POST
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item context) {
            if (context == null || !context.hasPermission(Item.CONFIGURE)) {
                return new ListBoxModel();
            }
            return new StandardListBoxModel().includeEmptyValue().includeMatchingAs(context instanceof Queue.Task ? Tasks.getAuthenticationOf2((Queue.Task)((Queue.Task)context)) : ACL.SYSTEM2, context, StandardCredentials.class, URIRequirementBuilder.create().build(), CredentialsMatchers.always());
        }
    }
}

