/*
 * Decompiled with CFR 0.152.
 */
package com.github.cyanbaz.jenkins.plugins.jsonparameter;

import com.github.cyanbaz.jenkins.plugins.jsonparameter.JsonSource;
import com.github.cyanbaz.jenkins.plugins.jsonparameter.Messages;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.cli.CLICommand;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.StringParameterValue;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest2;

public class JsonParameterDefinition
extends ParameterDefinition {
    private static final long serialVersionUID = 1L;
    private final String defaultValue;
    private final JsonSource source;
    private final String query;

    @DataBoundConstructor
    public JsonParameterDefinition(String name, String defaultValue, JsonSource source, String query) {
        super(name);
        this.defaultValue = defaultValue;
        this.source = source;
        this.query = query;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public JsonSource getSource() {
        return this.source;
    }

    public String getQuery() {
        return this.query;
    }

    public String getPlaceholderMessage() {
        return Messages.placeholder_select_option();
    }

    public ParameterValue getDefaultParameterValue() {
        return new StringParameterValue(this.getName(), this.defaultValue);
    }

    public ParameterValue createValue(StaplerRequest2 req, JSONObject jo) {
        Object value = jo.get("value");
        String stringValue = "";
        if (value instanceof String) {
            stringValue = (String)value;
        }
        return new StringParameterValue(this.getName(), stringValue);
    }

    public ParameterValue createValue(StaplerRequest2 req) {
        String[] value = req.getParameterValues(this.getName());
        String result = value == null || value.length == 0 || value[0].isEmpty() ? this.defaultValue : value[0];
        return new StringParameterValue(this.getName(), result);
    }

    public ParameterValue createValue(CLICommand command, String value) {
        if (value == null || value.isEmpty()) {
            return this.getDefaultParameterValue();
        }
        return new StringParameterValue(this.getName(), value);
    }

    @Extension
    @Symbol(value={"jsonParam"})
    public static class DescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        @NonNull
        public String getDisplayName() {
            return "JSON Parameter";
        }
    }
}

