/*
 * Decompiled with CFR 0.152.
 */
package com.github.cyanbaz.jenkins.plugins.jsonparameter;

import com.github.cyanbaz.jenkins.plugins.jsonparameter.JsonSource;
import com.github.cyanbaz.jenkins.plugins.jsonparameter.Messages;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.util.ListBoxModel;
import java.util.List;
import org.jenkinsci.Symbol;
import org.jenkinsci.lib.configprovider.ConfigProvider;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.plugins.configfiles.ConfigFiles;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.verb.POST;

public class ConfigFileSource
extends JsonSource {
    private final String configId;

    @DataBoundConstructor
    public ConfigFileSource(String configId) {
        this.configId = configId;
    }

    public String getConfigId() {
        return this.configId;
    }

    @Override
    public String loadJson() {
        Item item;
        Item item2 = item = Stapler.getCurrentRequest2() != null ? (Item)Stapler.getCurrentRequest2().findAncestorObject(Item.class) : null;
        if (item != null) {
            Config cfg = ConfigFiles.getByIdOrNull((Item)item, (String)this.configId);
            if (cfg == null) {
                throw new IllegalArgumentException(Messages.error_config_id_not_found(this.configId));
            }
            return cfg.content;
        }
        throw new IllegalStateException(Messages.error_jenkins_item_not_found());
    }

    @Extension
    @Symbol(value={"configFileSource"})
    public static class DescriptorImpl
    extends Descriptor<JsonSource> {
        @NonNull
        public String getDisplayName() {
            return "Config File";
        }

        @POST
        public ListBoxModel doFillConfigIdItems(@AncestorInPath Item item) {
            ListBoxModel items = new ListBoxModel();
            items.add(Messages.placeholder_config_file_id(), "");
            if (item != null) {
                item.checkPermission(Item.CONFIGURE);
                ItemGroup itemGroup = item.getParent();
                for (ConfigProvider provider : ConfigProvider.all()) {
                    List configIds = ConfigFiles.getConfigsInContext((ItemGroup)itemGroup, provider.getClass());
                    if (configIds.isEmpty()) continue;
                    for (Config cfg : configIds) {
                        this.addConfigIfValid(cfg, items);
                    }
                }
            }
            return items;
        }

        private void addConfigIfValid(Config cfg, ListBoxModel items) {
            if (cfg != null && cfg.id != null) {
                items.add(cfg.name + " (ID: " + cfg.id + ")", cfg.id);
            }
        }
    }
}

