// CHECKSTYLE:OFF

package com.github.cyanbaz.jenkins.plugins.jsonparameter;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code error.jenkins_item_not_found}: {@code No Jenkins item found
     * in the current request context.}.
     * 
     * @return
     *     {@code No Jenkins item found in the current request context.}
     */
    public static String error_jenkins_item_not_found() {
        return holder.format("error.jenkins_item_not_found");
    }

    /**
     * Key {@code error.jenkins_item_not_found}: {@code No Jenkins item found
     * in the current request context.}.
     * 
     * @return
     *     {@code No Jenkins item found in the current request context.}
     */
    public static Localizable _error_jenkins_item_not_found() {
        return new Localizable(holder, "error.jenkins_item_not_found");
    }

    /**
     * Key {@code error.config_id_not_found}: {@code The selected config ID
     * ''{0}'' does not exist.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The selected config ID ''{0}'' does not exist.}
     */
    public static String error_config_id_not_found(Object arg0) {
        return holder.format("error.config_id_not_found", arg0);
    }

    /**
     * Key {@code error.config_id_not_found}: {@code The selected config ID
     * ''{0}'' does not exist.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The selected config ID ''{0}'' does not exist.}
     */
    public static Localizable _error_config_id_not_found(Object arg0) {
        return new Localizable(holder, "error.config_id_not_found", arg0);
    }

    /**
     * Key {@code placeholder.config_file_id}: {@code -- Select --}.
     * 
     * @return
     *     {@code -- Select --}
     */
    public static String placeholder_config_file_id() {
        return holder.format("placeholder.config_file_id");
    }

    /**
     * Key {@code placeholder.config_file_id}: {@code -- Select --}.
     * 
     * @return
     *     {@code -- Select --}
     */
    public static Localizable _placeholder_config_file_id() {
        return new Localizable(holder, "placeholder.config_file_id");
    }

    /**
     * Key {@code placeholder.select_option}: {@code -- Choose an option --}.
     * 
     * @return
     *     {@code -- Choose an option --}
     */
    public static String placeholder_select_option() {
        return holder.format("placeholder.select_option");
    }

    /**
     * Key {@code placeholder.select_option}: {@code -- Choose an option --}.
     * 
     * @return
     *     {@code -- Choose an option --}
     */
    public static Localizable _placeholder_select_option() {
        return new Localizable(holder, "placeholder.select_option");
    }

    /**
     * Key {@code error.no_data}: {@code No data found. Check your JSON
     * source or query.}.
     * 
     * @return
     *     {@code No data found. Check your JSON source or query.}
     */
    public static String error_no_data() {
        return holder.format("error.no_data");
    }

    /**
     * Key {@code error.no_data}: {@code No data found. Check your JSON
     * source or query.}.
     * 
     * @return
     *     {@code No data found. Check your JSON source or query.}
     */
    public static Localizable _error_no_data() {
        return new Localizable(holder, "error.no_data");
    }

}
