/*
 * Decompiled with CFR 0.152.
 */
package com.github.cyanbaz.jenkins.plugins.jsonparameter;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.github.cyanbaz.jenkins.plugins.jsonparameter.JsonSource;
import com.github.cyanbaz.jenkins.plugins.jsonparameter.Messages;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.AutoCompletionCandidates;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.util.ListBoxModel;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.plugins.configfiles.GlobalConfigFiles;
import org.jenkinsci.plugins.configfiles.folder.FolderConfigFileProperty;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.verb.POST;

public class ConfigFileSource
extends JsonSource {
    private final boolean folderScoped;
    private final String folderPath;
    private final String configId;

    @DataBoundConstructor
    public ConfigFileSource(boolean folderScoped, String folderPath, String configId) {
        this.folderScoped = folderScoped;
        this.folderPath = folderPath;
        this.configId = configId;
    }

    public boolean isFolderScoped() {
        return this.folderScoped;
    }

    public String getFolderPath() {
        return this.folderPath;
    }

    public String getConfigId() {
        return this.configId;
    }

    @Override
    public String loadJson() {
        if (this.folderScoped) {
            return this.loadFolderScopedJson().orElseThrow(() -> new IllegalStateException(Messages.error_folder_scope()));
        }
        return this.loadGlobalJson().orElseThrow(() -> new IllegalArgumentException(Messages.error_config_id_not_found_global(this.configId)));
    }

    private Optional<String> loadFolderScopedJson() {
        Job job = (Job)Stapler.getCurrentRequest2().findAncestorObject(Job.class);
        if (job == null) {
            return Optional.empty();
        }
        AbstractFolder<?> folder = this.findMatchingFolder(job.getParent());
        if (folder == null) {
            return Optional.empty();
        }
        FolderConfigFileProperty prop = (FolderConfigFileProperty)folder.getProperties().get(FolderConfigFileProperty.class);
        if (prop == null) {
            return Optional.empty();
        }
        Config config = prop.getById(this.configId);
        if (config == null) {
            throw new IllegalArgumentException(Messages.error_config_id_not_found(this.configId));
        }
        return Optional.of(config.content);
    }

    private Optional<String> loadGlobalJson() {
        Config globalConfig = GlobalConfigFiles.get().getById(this.configId);
        return Optional.ofNullable(globalConfig).map(cfg -> cfg.content);
    }

    private AbstractFolder<?> findMatchingFolder(ItemGroup<?> start) {
        while (start instanceof AbstractFolder) {
            AbstractFolder folder = (AbstractFolder)start;
            if (folder.getFullName().equals(this.folderPath)) {
                return folder;
            }
            start = folder.getParent();
        }
        return null;
    }

    @Extension
    @Symbol(value={"configFileSource"})
    public static class DescriptorImpl
    extends Descriptor<JsonSource> {
        @NonNull
        public String getDisplayName() {
            return "Jenkins Config File";
        }

        @POST
        public AutoCompletionCandidates doAutoCompleteFolderPath(@AncestorInPath Item item, @QueryParameter String value) {
            AutoCompletionCandidates candidates = new AutoCompletionCandidates();
            if (item != null) {
                item.checkPermission(Item.CONFIGURE);
                String prefix = value != null ? value.trim() : "";
                for (AbstractFolder folder : Jenkins.get().getAllItems(AbstractFolder.class)) {
                    String remaining;
                    String fullName = folder.getFullName();
                    if (!item.getFullName().startsWith(fullName) || !fullName.startsWith(prefix) || (remaining = fullName.substring(prefix.length())).contains("/")) continue;
                    candidates.add(fullName);
                }
            }
            return candidates;
        }

        @POST
        public ListBoxModel doFillConfigIdItems(@AncestorInPath Item item) {
            ListBoxModel items = new ListBoxModel();
            items.add(Messages.placeholder_config_file_id(), "");
            if (item != null) {
                item.checkPermission(Item.CONFIGURE);
                HashSet<String> seenIds = new HashSet<String>();
                this.addFolderConfigs(item, items, seenIds);
                this.addGlobalConfigs(items, seenIds);
            }
            return items;
        }

        private void addFolderConfigs(Item item, ListBoxModel items, Set<String> seenIds) {
            ItemGroup parent = item.getParent();
            while (parent instanceof AbstractFolder) {
                AbstractFolder folder = (AbstractFolder)parent;
                FolderConfigFileProperty prop = (FolderConfigFileProperty)folder.getProperties().get(FolderConfigFileProperty.class);
                if (prop != null) {
                    for (Config cfg : prop.getConfigs()) {
                        this.addConfigIfValid(cfg, seenIds, items);
                    }
                }
                parent = folder.getParent();
            }
        }

        private void addGlobalConfigs(ListBoxModel items, Set<String> seenIds) {
            for (Config cfg : GlobalConfigFiles.get().getConfigs()) {
                this.addConfigIfValid(cfg, seenIds, items);
            }
        }

        private void addConfigIfValid(Config cfg, Set<String> seenIds, ListBoxModel items) {
            if (cfg != null && cfg.id != null && seenIds.add(cfg.id)) {
                items.add(cfg.name + " (ID: " + cfg.id + ")", cfg.id);
            }
        }
    }
}

