/*
 * Decompiled with CFR 0.152.
 */
package com.github.cyanbaz.jenkins.plugins.jsonparameter;

public class JsonResult<T> {
    private final boolean success;
    private final T value;
    private final String errorMessage;

    public JsonResult(boolean success, T value, String errorMessage) {
        this.success = success;
        this.value = value;
        this.errorMessage = errorMessage;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public T getValue() {
        return this.value;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public static <T> JsonResult<T> success(T value) {
        return new JsonResult<T>(true, value, null);
    }

    public static <T> JsonResult<T> failure(String errorMessage) {
        return new JsonResult<Object>(false, null, errorMessage);
    }
}

