/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.jfrog.callables;

import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.util.Secret;
import io.jenkins.plugins.jfrog.JenkinsBuildInfoLog;
import io.jenkins.plugins.jfrog.OsUtils;
import io.jenkins.plugins.jfrog.configuration.JFrogPlatformInstance;
import io.jenkins.plugins.jfrog.configuration.JenkinsProxyConfiguration;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import jenkins.MasterToSlaveFileCallable;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.client.ProxyConfiguration;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.ArtifactoryManager;

public class JFrogCliDownloader
extends MasterToSlaveFileCallable<Void> {
    private static final String SHA256_FILE_NAME = "sha256";
    private static final String RELEASE = "[RELEASE]";
    JenkinsProxyConfiguration proxyConfiguration;
    private String providedVersion;
    JFrogPlatformInstance instance;
    private TaskListener log;
    String repository;
    String binaryName;

    public Void invoke(File toolLocation, VirtualChannel channel) throws IOException, InterruptedException {
        this.log.getLogger().println("[JFrogCliDownloader] Starting CLI download");
        String version = (String)StringUtils.defaultIfBlank((CharSequence)this.providedVersion, (CharSequence)RELEASE);
        String cliUrlSuffix = String.format("/%s/v2-jf/%s/jfrog-cli-%s/%s", this.repository, version, OsUtils.getOsDetails(), this.binaryName);
        JenkinsBuildInfoLog buildInfoLog = new JenkinsBuildInfoLog(this.log);
        String artifactoryUrl = this.instance.inferArtifactoryUrl();
        try (ArtifactoryManager manager = new ArtifactoryManager(artifactoryUrl, Secret.toString((Secret)this.instance.getCredentialsConfig().getUsername()), Secret.toString((Secret)this.instance.getCredentialsConfig().getPassword()), Secret.toString((Secret)this.instance.getCredentialsConfig().getAccessToken()), (Log)buildInfoLog);){
            String artifactorySha256;
            if (this.proxyConfiguration.isProxyConfigured(artifactoryUrl)) {
                manager.setProxyConfiguration((ProxyConfiguration)this.proxyConfiguration);
            }
            if (JFrogCliDownloader.shouldDownloadTool(toolLocation, artifactorySha256 = JFrogCliDownloader.getArtifactSha256(manager, cliUrlSuffix))) {
                if (version.equals(RELEASE)) {
                    this.log.getLogger().printf("[JFrogCliDownloader] Download '%s' latest version from: %s%n", this.binaryName, artifactoryUrl + cliUrlSuffix);
                } else {
                    this.log.getLogger().printf("[JFrogCliDownloader] Download '%s' version %s from: %s%n", this.binaryName, version, artifactoryUrl + cliUrlSuffix);
                }
                this.performAtomicDownload(manager, cliUrlSuffix, toolLocation, artifactorySha256);
            } else {
                this.log.getLogger().println("[JFrogCliDownloader] CLI is up-to-date, skipping download");
            }
        }
        this.log.getLogger().println("[JFrogCliDownloader] Download completed successfully");
        return null;
    }

    private void performAtomicDownload(ArtifactoryManager manager, String cliUrlSuffix, File toolLocation, String artifactorySha256) throws IOException {
        String stageName = this.getStageNameFromThread();
        String tempFileName = this.binaryName + ".tmp." + stageName + "." + System.currentTimeMillis() + "." + Thread.currentThread().getId() + "." + System.nanoTime();
        File temporaryDownloadFile = new File(toolLocation, tempFileName);
        File finalCliExecutable = new File(toolLocation, this.binaryName);
        this.log.getLogger().println("[JFrogCliDownloader] Temporary download file: " + temporaryDownloadFile.getAbsolutePath());
        this.log.getLogger().println("[JFrogCliDownloader] Final CLI executable: " + finalCliExecutable.getAbsolutePath());
        try {
            this.log.getLogger().println("[JFrogCliDownloader] Downloading to temporary file");
            File downloadResponse = manager.downloadToFile(cliUrlSuffix, temporaryDownloadFile.getPath());
            this.log.getLogger().println("[JFrogCliDownloader] Verifying download integrity");
            if (!temporaryDownloadFile.exists()) {
                throw new IOException("Downloaded file doesn't exist: " + temporaryDownloadFile.getAbsolutePath());
            }
            long fileSize = temporaryDownloadFile.length();
            if (fileSize == 0L) {
                throw new IOException("Downloaded file is empty: " + temporaryDownloadFile.getAbsolutePath());
            }
            this.log.getLogger().println("[JFrogCliDownloader] Download verified: " + fileSize / 1024L / 1024L + "MB");
            this.log.getLogger().println("[JFrogCliDownloader] Moving to final location");
            if (finalCliExecutable.exists()) {
                this.log.getLogger().println("[JFrogCliDownloader] Removing existing CLI binary to replace with new version");
                if (!finalCliExecutable.delete()) {
                    throw new IOException("Failed to remove existing CLI binary: " + finalCliExecutable.getAbsolutePath());
                }
            }
            if (!temporaryDownloadFile.renameTo(finalCliExecutable)) {
                throw new IOException("Failed to move temporary file to final location. Temp: " + temporaryDownloadFile.getAbsolutePath() + ", Final: " + finalCliExecutable.getAbsolutePath());
            }
            this.log.getLogger().println("[JFrogCliDownloader] Setting executable permissions");
            if (!finalCliExecutable.setExecutable(true)) {
                throw new IOException("No permission to add execution permission to binary: " + finalCliExecutable.getAbsolutePath());
            }
            this.log.getLogger().println("[JFrogCliDownloader] Creating SHA256 verification file");
            JFrogCliDownloader.createSha256File(toolLocation, artifactorySha256);
            this.log.getLogger().println("[JFrogCliDownloader] Download and installation completed successfully");
        }
        catch (Exception e) {
            this.log.getLogger().println("[JFrogCliDownloader] Download failed, cleaning up temporary file");
            this.cleanupTempFile(temporaryDownloadFile);
            throw e;
        }
    }

    private void cleanupTempFile(File tempFile) {
        try {
            if (tempFile != null && tempFile.exists()) {
                if (tempFile.delete()) {
                    this.log.getLogger().println("[JFrogCliDownloader] Cleaned up temporary file: " + tempFile.getAbsolutePath());
                } else {
                    this.log.getLogger().println("[JFrogCliDownloader] Failed to delete temporary file: " + tempFile.getAbsolutePath());
                }
            }
        }
        catch (Exception e) {
            this.log.getLogger().println("[JFrogCliDownloader] Error during cleanup: " + e.getMessage());
        }
    }

    private static void createSha256File(File toolLocation, String artifactorySha256) throws IOException {
        File file = new File(toolLocation, SHA256_FILE_NAME);
        Files.write(file.toPath(), artifactorySha256.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    private static boolean shouldDownloadTool(File toolLocation, String artifactorySha256) throws IOException {
        if (artifactorySha256.isEmpty()) {
            return true;
        }
        Path path = toolLocation.toPath().resolve(SHA256_FILE_NAME);
        if (!Files.exists(path, new LinkOption[0])) {
            return true;
        }
        String fileContent = new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
        return !StringUtils.equals((CharSequence)fileContent, (CharSequence)artifactorySha256);
    }

    private static String getArtifactSha256(ArtifactoryManager manager, String cliUrlSuffix) throws IOException {
        Header[] headers;
        for (Header header : headers = manager.downloadHeaders(cliUrlSuffix)) {
            if (!header.getName().equalsIgnoreCase("X-Checksum-Sha256")) continue;
            return header.getValue();
        }
        return "";
    }

    private String getStageNameFromThread() {
        try {
            String threadName = Thread.currentThread().getName();
            if (threadName.contains("Parallel")) {
                String stageName = threadName.replaceAll("[^a-zA-Z0-9]", "_");
                return stageName.length() > 20 ? stageName.substring(0, 20) : stageName;
            }
            return "thread" + Thread.currentThread().getId();
        }
        catch (Exception e) {
            return "unknown";
        }
    }

    public JFrogCliDownloader(JenkinsProxyConfiguration proxyConfiguration, String providedVersion, JFrogPlatformInstance instance, TaskListener log, String repository, String binaryName) {
        this.proxyConfiguration = proxyConfiguration;
        this.providedVersion = providedVersion;
        this.instance = instance;
        this.log = log;
        this.repository = repository;
        this.binaryName = binaryName;
    }
}

