/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.jfrog;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.ArgumentListBuilder;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.jfrog.CliEnvConfigurator;
import io.jenkins.plugins.jfrog.JenkinsBuildInfoLog;
import io.jenkins.plugins.jfrog.JfStep;
import io.jenkins.plugins.jfrog.JfTaskListener;
import io.jenkins.plugins.jfrog.JfrogInstallation;
import io.jenkins.plugins.jfrog.Utils;
import io.jenkins.plugins.jfrog.actions.JFrogCliConfigEncryption;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jenkinsci.Symbol;
import org.jfrog.build.client.Version;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class JfrogBuilder
extends Builder {
    private static final String JFROG_CLI_CONFIG_FILE = "jfrog-cli.conf";
    private String command;
    private String jfrogInstallation;

    @DataBoundConstructor
    public JfrogBuilder(String command) {
        this.command = command;
    }

    @DataBoundSetter
    public void setCommand(String command) {
        this.command = command;
    }

    @DataBoundSetter
    public void setJfrogInstallation(String jfrogInstallation) {
        this.jfrogInstallation = jfrogInstallation;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        String[] args;
        JfrogInstallation installation;
        FilePath workspace = build.getWorkspace();
        if (workspace == null) {
            listener.error("Workspace is null");
            return false;
        }
        EnvVars env = build.getEnvironment((TaskListener)listener);
        if (StringUtils.isNotBlank((CharSequence)this.jfrogInstallation) && (installation = this.getInstallation()) != null) {
            Node node = build.getBuiltOn();
            if (node != null) {
                installation = installation.forNode(node, (TaskListener)listener);
            }
            if (installation != null) {
                installation = installation.forEnvironment(env);
            }
            if (installation != null) {
                installation.buildEnvVars(env);
            }
        }
        workspace.mkdirs();
        if (StringUtils.isBlank((CharSequence)this.command)) {
            listener.error("No JFrog CLI command provided");
            return false;
        }
        String trimmedCommand = this.command.trim();
        if (!trimmedCommand.startsWith("jf ") && !trimmedCommand.startsWith("jfrog ")) {
            listener.error("JFrog CLI command must start with 'jf' or 'jfrog' followed by a subcommand (e.g., 'jf rt ping' or 'jfrog rt ping')");
            return false;
        }
        String[] fullArgs = StringUtils.split((String)trimmedCommand);
        if (fullArgs.length > 0 && (fullArgs[0].equals("jf") || fullArgs[0].equals("jfrog"))) {
            args = new String[fullArgs.length - 1];
            System.arraycopy(fullArgs, 1, args, 0, args.length);
        } else {
            args = fullArgs;
        }
        ArgumentListBuilder builder = new ArgumentListBuilder();
        boolean isWindows = !launcher.isUnix();
        String jfrogBinaryPath = Utils.getJFrogCLIPath(env, isWindows);
        boolean passwordStdinSupported = this.isPasswordStdinEnabled(workspace, env, launcher, jfrogBinaryPath, (TaskListener)listener);
        builder.add(jfrogBinaryPath).add(args);
        if (isWindows) {
            builder = builder.toWindowsCommand();
        }
        try (ByteArrayOutputStream taskOutputStream = new ByteArrayOutputStream();){
            JfTaskListener jfTaskListener = new JfTaskListener((TaskListener)listener, taskOutputStream);
            Launcher.ProcStarter jfLauncher = this.setupJFrogEnvironment((Run<?, ?>)build, env, launcher, jfTaskListener, workspace, jfrogBinaryPath, isWindows, passwordStdinSupported, (TaskListener)listener);
            int exitValue = jfLauncher.cmds(builder).join();
            if (exitValue != 0) {
                listener.error("Running 'jf' command failed with exit code " + exitValue);
                listener.error("Please check the console output above for detailed error information.");
                boolean bl = false;
                return bl;
            }
            JfStep.addBuildInfoActionIfNeeded(args, new JenkinsBuildInfoLog((TaskListener)listener), build, taskOutputStream);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            if (e.getMessage() != null && (e.getMessage().contains("No such file or directory") || e.getMessage().contains("Cannot run program"))) {
                listener.error("JFrog CLI (jf) not found. Please configure JFrog CLI as a tool:");
                listener.error("  1. Go to 'Manage Jenkins' \u2192 'Global Tool Configuration'");
                listener.error("  2. Add JFrog CLI installation under 'JFrog CLI' section");
                listener.error("  3. Either set automatic installation or provide the path to JFrog CLI");
                listener.error("Error details: " + ExceptionUtils.getRootCauseMessage((Throwable)e));
                return false;
            }
            listener.error("Couldn't execute 'jf' command. " + ExceptionUtils.getRootCauseMessage((Throwable)e));
            return false;
        }
        catch (Exception e) {
            String errorMessage = "Couldn't execute 'jf' command. " + ExceptionUtils.getRootCauseMessage((Throwable)e);
            listener.error(errorMessage);
            return false;
        }
    }

    private JfrogInstallation getInstallation() {
        if (this.jfrogInstallation == null) {
            return null;
        }
        if (!(this.getDescriptor() instanceof DescriptorImpl)) {
            return null;
        }
        JfrogInstallation[] installations = ((DescriptorImpl)this.getDescriptor()).getInstallations();
        if (installations == null) {
            return null;
        }
        for (JfrogInstallation installation : installations) {
            if (installation == null || !this.jfrogInstallation.equals(installation.getName())) continue;
            return installation;
        }
        return null;
    }

    static String getJFrogCLIPath(EnvVars env, boolean isWindows) {
        String jfrogBinaryPath = Paths.get(env.get("JFROG_BINARY_PATH", ""), Utils.getJfrogCliBinaryName(isWindows)).toString();
        return isWindows ? FilenameUtils.separatorsToWindows((String)jfrogBinaryPath) : FilenameUtils.separatorsToUnix((String)jfrogBinaryPath);
    }

    private Launcher.ProcStarter setupJFrogEnvironment(Run<?, ?> run, EnvVars env, Launcher launcher, TaskListener cliOutputListener, FilePath workspace, String jfrogBinaryPath, boolean isWindows, boolean passwordStdinSupported, TaskListener consoleListener) throws IOException, InterruptedException {
        JFrogCliConfigEncryption jfrogCliConfigEncryption = (JFrogCliConfigEncryption)run.getAction(JFrogCliConfigEncryption.class);
        if (jfrogCliConfigEncryption == null) {
            jfrogCliConfigEncryption = new JFrogCliConfigEncryption(env);
            run.addAction((Action)jfrogCliConfigEncryption);
        }
        FilePath jfrogHomeTempDir = Utils.createAndGetJfrogCliHomeTempDir(workspace, String.valueOf(run.getNumber()));
        CliEnvConfigurator.configureCliEnv(env, jfrogHomeTempDir.getRemote(), jfrogCliConfigEncryption);
        Launcher.ProcStarter jfLauncher = launcher.launch().envs((Map)env).pwd(workspace).stdout(cliOutputListener);
        if (this.shouldConfig(jfrogHomeTempDir)) {
            this.logIfNoToolProvided(env, consoleListener);
            JfStep.Execution.configAllServersForBuilder(jfLauncher, jfrogBinaryPath, isWindows, run.getParent(), passwordStdinSupported);
        }
        return jfLauncher;
    }

    private boolean shouldConfig(FilePath jfrogHomeTempDir) throws IOException, InterruptedException {
        if (jfrogHomeTempDir == null || !jfrogHomeTempDir.exists()) {
            return true;
        }
        List filesList = jfrogHomeTempDir.list();
        for (FilePath file : filesList) {
            if (file == null || !file.getName().contains(JFROG_CLI_CONFIG_FILE)) continue;
            return false;
        }
        return true;
    }

    private void logIfNoToolProvided(EnvVars env, TaskListener listener) {
        if (!env.containsKey((Object)"JFROG_BINARY_PATH")) {
            JenkinsBuildInfoLog buildInfoLog = new JenkinsBuildInfoLog(listener);
            buildInfoLog.info("A 'jfrog' tool was not set. Using JFrog CLI from the system path.");
        }
    }

    private boolean isPasswordStdinEnabled(FilePath workspace, EnvVars env, Launcher launcher, String jfrogBinaryPath, TaskListener listener) {
        try {
            JenkinsBuildInfoLog buildInfoLog = new JenkinsBuildInfoLog(listener);
            String readJFrogCliPwdStdinSupport = env.get("JFROG_CLI_PASSWORD_STDIN_SUPPORT", "");
            Launcher.ProcStarter procStarter = launcher.launch().envs((Map)env).pwd(workspace);
            Version currentCliVersion = JfStep.getJfrogCliVersion(procStarter, jfrogBinaryPath);
            boolean isMinimumCLIVersionPasswdSTDIN = currentCliVersion.isAtLeast(JfStep.MIN_CLI_VERSION_PASSWORD_STDIN);
            if (StringUtils.isBlank((CharSequence)readJFrogCliPwdStdinSupport)) {
                boolean isPluginLauncher = launcher.getClass().getName().contains("org.jenkinsci.plugins");
                if (isPluginLauncher) {
                    buildInfoLog.debug("Password stdin is not supported, Launcher is a plugin launcher.");
                    return false;
                }
                buildInfoLog.debug("Password stdin is supported");
                return isMinimumCLIVersionPasswdSTDIN;
            }
            boolean isSupported = Boolean.parseBoolean(readJFrogCliPwdStdinSupport);
            if (isSupported && !isMinimumCLIVersionPasswdSTDIN) {
                buildInfoLog.error("Password input via stdin is not supported, JFrog CLI version is below the minimum required version.");
            }
            return isSupported && isMinimumCLIVersionPasswdSTDIN;
        }
        catch (IOException | InterruptedException e) {
            return false;
        }
    }

    public String getCommand() {
        return this.command;
    }

    public String getJfrogInstallation() {
        return this.jfrogInstallation;
    }

    @Extension
    @Symbol(value={"jfrogCli"})
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        @Nonnull
        public String getDisplayName() {
            return "Run JFrog CLI";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public JfrogInstallation[] getInstallations() {
            return (JfrogInstallation[])((JfrogInstallation.DescriptorImpl)Jenkins.get().getDescriptorByType(JfrogInstallation.DescriptorImpl.class)).getInstallations();
        }

        public ListBoxModel doFillJfrogInstallationItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("(Use JFrog CLI from system PATH)", "");
            for (JfrogInstallation installation : this.getInstallations()) {
                items.add(installation.getName(), installation.getName());
            }
            return items;
        }
    }
}

