/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.jfrog;

import hudson.Extension;
import hudson.FilePath;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.tools.ToolInstallation;
import hudson.util.FormValidation;
import io.jenkins.plugins.jfrog.BinaryInstaller;
import io.jenkins.plugins.jfrog.JfrogInstallation;
import io.jenkins.plugins.jfrog.Utils;
import io.jenkins.plugins.jfrog.configuration.CredentialsConfig;
import io.jenkins.plugins.jfrog.configuration.JFrogPlatformBuilder;
import io.jenkins.plugins.jfrog.configuration.JFrogPlatformInstance;
import io.jenkins.plugins.jfrog.plugins.PluginsUtils;
import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.build.client.Version;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class ArtifactoryInstaller
extends BinaryInstaller {
    private static final Version MIN_CLI_VERSION = new Version("2.6.1");
    private static final Pattern VERSION_PATTERN = Pattern.compile("^\\d+\\.\\d+\\.\\d+$");
    static final String BAD_VERSION_PATTERN_ERROR = "Version must be in the form of X.X.X";
    static final String LOW_VERSION_PATTERN_ERROR = "The provided JFrog CLI version must be at least " + MIN_CLI_VERSION;
    final String serverId;
    final String repository;
    String version;

    @DataBoundConstructor
    public ArtifactoryInstaller(String serverId, String repository, String version) {
        super(null);
        this.serverId = serverId;
        this.repository = StringUtils.trim((String)repository);
        this.version = StringUtils.trim((String)version);
    }

    public FilePath performInstallation(ToolInstallation tool, Node node, TaskListener log) throws IOException, InterruptedException {
        JFrogPlatformInstance server = this.getSpecificServer(this.getServerId());
        if (server == null) {
            throw new IOException("Server id '" + this.getServerId() + "' doesn't exists.");
        }
        String binaryName = Utils.getJfrogCliBinaryName(!node.createLauncher(log).isUnix());
        return ArtifactoryInstaller.performJfrogCliInstallation(this.getToolLocation(tool, node), log, this.getVersion(), server, this.getRepository(), binaryName);
    }

    JFrogPlatformInstance getSpecificServer(String id) {
        List<JFrogPlatformInstance> jfrogInstances = JFrogPlatformBuilder.getJFrogPlatformInstances();
        if (jfrogInstances != null && !jfrogInstances.isEmpty()) {
            for (JFrogPlatformInstance jfrogPlatformInstance : jfrogInstances) {
                if (!jfrogPlatformInstance.getId().equals(id)) continue;
                String credentialsId = jfrogPlatformInstance.getCredentialsConfig().getCredentialsId();
                jfrogPlatformInstance.setCredentialsConfig(new CredentialsConfig(credentialsId, PluginsUtils.credentialsLookup(credentialsId, null)));
                return jfrogPlatformInstance;
            }
        }
        return null;
    }

    static FormValidation validateCliVersion(@QueryParameter String version) {
        if (StringUtils.isBlank((CharSequence)version)) {
            return FormValidation.ok();
        }
        if (!VERSION_PATTERN.matcher(version).matches()) {
            return FormValidation.error((String)BAD_VERSION_PATTERN_ERROR);
        }
        if (!new Version(version).isAtLeast(MIN_CLI_VERSION)) {
            return FormValidation.error((String)LOW_VERSION_PATTERN_ERROR);
        }
        return FormValidation.ok();
    }

    public String getServerId() {
        return this.serverId;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Extension
    public static final class DescriptorImpl
    extends BinaryInstaller.DescriptorImpl<ArtifactoryInstaller> {
        @Nonnull
        public String getDisplayName() {
            return "Install from Artifactory";
        }

        public boolean isApplicable(Class<? extends ToolInstallation> toolType) {
            return toolType == JfrogInstallation.class;
        }

        public List<JFrogPlatformInstance> getServerIds() {
            return JFrogPlatformBuilder.getJFrogPlatformInstances();
        }

        @POST
        public FormValidation doCheckRepository(@QueryParameter String repository) {
            if (StringUtils.isBlank((CharSequence)repository)) {
                return FormValidation.error((String)"Required");
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckVersion(@QueryParameter String version) {
            return ArtifactoryInstaller.validateCliVersion(version);
        }
    }
}

