/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.jfrog.configuration;

import io.jenkins.plugins.jfrog.configuration.CredentialsConfig;
import io.jenkins.plugins.jfrog.configuration.JFrogPlatformBuilder;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class JFrogPlatformInstance
implements Serializable {
    private static final String DISTRIBUTION_SUFFIX = "/distribution";
    private static final String ARTIFACTORY_SUFFIX = "/artifactory";
    private static final String XRAY_SUFFIX = "/xray";
    private String url;
    private String artifactoryUrl;
    private String distributionUrl;
    private String xrayUrl;
    private String id;
    private CredentialsConfig credentialsConfig;

    @DataBoundConstructor
    public JFrogPlatformInstance(String serverId, String url, CredentialsConfig credentialsConfig, String artifactoryUrl, String distributionUrl, String xrayUrl) {
        this.id = serverId;
        this.credentialsConfig = credentialsConfig;
        this.url = StringUtils.removeEnd((String)url, (String)"/");
        this.artifactoryUrl = StringUtils.removeEnd((String)artifactoryUrl, (String)"/");
        this.distributionUrl = StringUtils.removeEnd((String)distributionUrl, (String)"/");
        this.xrayUrl = StringUtils.removeEnd((String)xrayUrl, (String)"/");
    }

    public List<JFrogPlatformInstance> getJfrogInstances() {
        return JFrogPlatformBuilder.getJFrogPlatformInstances();
    }

    public String getServerId() {
        return this.getId();
    }

    public void setServerId(String serverId) {
        this.id = serverId;
    }

    public String inferArtifactoryUrl() {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.artifactoryUrl, (CharSequence)(this.url + ARTIFACTORY_SUFFIX));
    }

    public String inferDistributionUrl() {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.distributionUrl, (CharSequence)(this.url + DISTRIBUTION_SUFFIX));
    }

    public String inferXrayUrl() {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.xrayUrl, (CharSequence)(this.url + XRAY_SUFFIX));
    }

    public String getUrl() {
        return this.url;
    }

    public String getArtifactoryUrl() {
        return this.artifactoryUrl;
    }

    public String getDistributionUrl() {
        return this.distributionUrl;
    }

    public String getXrayUrl() {
        return this.xrayUrl;
    }

    public String getId() {
        return this.id;
    }

    public CredentialsConfig getCredentialsConfig() {
        return this.credentialsConfig;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setArtifactoryUrl(String artifactoryUrl) {
        this.artifactoryUrl = artifactoryUrl;
    }

    public void setDistributionUrl(String distributionUrl) {
        this.distributionUrl = distributionUrl;
    }

    public void setXrayUrl(String xrayUrl) {
        this.xrayUrl = xrayUrl;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setCredentialsConfig(CredentialsConfig credentialsConfig) {
        this.credentialsConfig = credentialsConfig;
    }
}

