/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.jfrog;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Action;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.ArgumentListBuilder;
import io.jenkins.plugins.jfrog.CliEnvConfigurator;
import io.jenkins.plugins.jfrog.JenkinsBuildInfoLog;
import io.jenkins.plugins.jfrog.JfTaskListener;
import io.jenkins.plugins.jfrog.Utils;
import io.jenkins.plugins.jfrog.actions.BuildInfoBuildBadgeAction;
import io.jenkins.plugins.jfrog.actions.JFrogCliConfigEncryption;
import io.jenkins.plugins.jfrog.configuration.Credentials;
import io.jenkins.plugins.jfrog.configuration.JFrogPlatformBuilder;
import io.jenkins.plugins.jfrog.configuration.JFrogPlatformInstance;
import io.jenkins.plugins.jfrog.models.BuildInfoOutputModel;
import io.jenkins.plugins.jfrog.plugins.PluginsUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.client.Version;
import org.jfrog.build.extractor.BuildInfoExtractorUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class JfStep
extends Step {
    private static final ObjectMapper mapper = BuildInfoExtractorUtils.createMapper();
    protected String[] args;
    static final Version MIN_CLI_VERSION_PASSWORD_STDIN = new Version("2.31.3");

    @DataBoundConstructor
    public JfStep(Object args) {
        if (args instanceof List) {
            this.args = (String[])((List)args).toArray(String[]::new);
            return;
        }
        this.args = StringUtils.split((String)args.toString());
    }

    public static Version getJfrogCliVersion(Launcher.ProcStarter launcher, String jfrogBinaryPath) throws IOException, InterruptedException {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            ArgumentListBuilder builder = new ArgumentListBuilder();
            builder.add(jfrogBinaryPath).add("-v");
            int exitCode = launcher.cmds(builder).pwd(launcher.pwd()).stdout((OutputStream)outputStream).join();
            if (exitCode != 0) {
                throw new IOException("Failed to get JFrog CLI version: " + outputStream.toString(StandardCharsets.UTF_8));
            }
            String versionOutput = outputStream.toString(StandardCharsets.UTF_8).trim();
            String version = StringUtils.substringAfterLast((String)versionOutput, (String)" ");
            Version version2 = new Version(version);
            return version2;
        }
    }

    public StepExecution start(StepContext context) {
        return new Execution(this.args, context);
    }

    static void addCredentialsArguments(ArgumentListBuilder builder, JFrogPlatformInstance jfrogPlatformInstance, Job<?, ?> job, Launcher.ProcStarter launcher, boolean passwordStdinSupported) {
        String credentialsId = jfrogPlatformInstance.getCredentialsConfig().getCredentialsId();
        StringCredentials accessTokenCredentials = PluginsUtils.accessTokenCredentialsLookup(credentialsId, job);
        if (accessTokenCredentials != null) {
            builder.addMasked("--access-token=" + accessTokenCredentials.getSecret().getPlainText());
        } else {
            Credentials credentials = PluginsUtils.credentialsLookup(credentialsId, job);
            builder.add("--user=" + credentials.getUsername());
            JfStep.addPasswordArgument(builder, credentials, launcher, passwordStdinSupported);
        }
    }

    private static void addPasswordArgument(ArgumentListBuilder builder, Credentials credentials, Launcher.ProcStarter launcher, boolean passwordStdinSupported) {
        if (passwordStdinSupported) {
            builder.add("--password-stdin");
            ByteArrayInputStream inputStream = new ByteArrayInputStream(credentials.getPassword().getPlainText().getBytes(StandardCharsets.UTF_8));
            launcher.stdin((InputStream)inputStream);
        } else {
            builder.addMasked("--password=" + credentials.getPassword());
        }
    }

    private static void addUrlArguments(ArgumentListBuilder builder, JFrogPlatformInstance jfrogPlatformInstance) {
        builder.add("--url=" + jfrogPlatformInstance.getUrl());
        builder.add("--artifactory-url=" + jfrogPlatformInstance.inferArtifactoryUrl());
        builder.add("--distribution-url=" + jfrogPlatformInstance.inferDistributionUrl());
        builder.add("--xray-url=" + jfrogPlatformInstance.inferXrayUrl());
    }

    static void addBuildInfoActionIfNeeded(String[] args, Log log, Run<?, ?> run, ByteArrayOutputStream taskOutputStream) {
        BuildInfoOutputModel buildInfoOutputModel;
        if (args.length < 2 || !args[0].equals("rt") || !StringUtils.equalsAny((CharSequence)args[1], (CharSequence[])new CharSequence[]{"bp", "build-publish"})) {
            return;
        }
        String taskOutput = taskOutputStream.toString(StandardCharsets.UTF_8);
        if ((taskOutput = StringUtils.substringBetween((String)taskOutput, (String)"{", (String)"}")) == null) {
            JfStep.logIllegalBuildPublishOutput(log, taskOutputStream);
            return;
        }
        try {
            buildInfoOutputModel = (BuildInfoOutputModel)mapper.readValue("{" + taskOutput + "}", BuildInfoOutputModel.class);
            if (buildInfoOutputModel == null) {
                JfStep.logIllegalBuildPublishOutput(log, taskOutputStream);
                return;
            }
        }
        catch (JsonProcessingException e) {
            JfStep.logIllegalBuildPublishOutput(log, taskOutputStream);
            log.warn(ExceptionUtils.getRootCauseMessage((Throwable)e));
            return;
        }
        String buildInfoUrl = buildInfoOutputModel.getBuildInfoUiUrl();
        if (StringUtils.isNotBlank((CharSequence)buildInfoUrl)) {
            run.addAction((Action)new BuildInfoBuildBadgeAction(buildInfoUrl));
        }
    }

    private static void logIllegalBuildPublishOutput(Log log, ByteArrayOutputStream taskOutputStream) {
        log.warn("Illegal build-publish output: " + taskOutputStream.toString(StandardCharsets.UTF_8));
    }

    public String[] getArgs() {
        return this.args;
    }

    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "jf";
        }

        @Nonnull
        public String getDisplayName() {
            return "jf command";
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return Set.of(Launcher.class, FilePath.class, TaskListener.class, EnvVars.class);
        }
    }

    public static class Execution
    extends SynchronousNonBlockingStepExecution<String> {
        private final String[] args;

        protected Execution(String[] args, @Nonnull StepContext context) {
            super(context);
            this.args = args;
        }

        protected String run() throws Exception {
            String output;
            Launcher launcher = (Launcher)this.getContext().get(Launcher.class);
            FilePath workspace = (FilePath)this.getContext().get(FilePath.class);
            TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
            EnvVars env = (EnvVars)this.getContext().get(EnvVars.class);
            Run run = (Run)this.getContext().get(Run.class);
            workspace.mkdirs();
            ArgumentListBuilder builder = new ArgumentListBuilder();
            boolean isWindows = !launcher.isUnix();
            String jfrogBinaryPath = Execution.getJFrogCLIPath(env, isWindows);
            boolean passwordStdinSupported = this.isPasswordStdinEnabled(workspace, env, launcher, jfrogBinaryPath);
            builder.add(jfrogBinaryPath).add(this.args);
            if (isWindows) {
                builder = builder.toWindowsCommand();
            }
            try (ByteArrayOutputStream taskOutputStream = new ByteArrayOutputStream();){
                JfTaskListener jfTaskListener = new JfTaskListener(listener, taskOutputStream);
                Launcher.ProcStarter jfLauncher = this.setupJFrogEnvironment(run, env, launcher, jfTaskListener, workspace, jfrogBinaryPath, isWindows, passwordStdinSupported);
                int exitValue = jfLauncher.cmds(builder).join();
                output = taskOutputStream.toString(StandardCharsets.UTF_8);
                if (exitValue != 0) {
                    throw new RuntimeException("Running 'jf' command failed with exit code " + exitValue);
                }
                JfStep.addBuildInfoActionIfNeeded(this.args, new JenkinsBuildInfoLog(listener), run, taskOutputStream);
            }
            catch (Exception e) {
                String errorMessage = "Couldn't execute 'jf' command. " + ExceptionUtils.getRootCauseMessage((Throwable)e);
                throw new RuntimeException(errorMessage, e);
            }
            return output;
        }

        static String getJFrogCLIPath(EnvVars env, boolean isWindows) {
            String jfrogBinaryPath = Paths.get(env.get("JFROG_BINARY_PATH", ""), Utils.getJfrogCliBinaryName(isWindows)).toString();
            return isWindows ? FilenameUtils.separatorsToWindows((String)jfrogBinaryPath) : FilenameUtils.separatorsToUnix((String)jfrogBinaryPath);
        }

        private void logIfNoToolProvided(EnvVars env, TaskListener listener) {
            if (env.containsKey((Object)"JFROG_BINARY_PATH")) {
                return;
            }
            JenkinsBuildInfoLog buildInfoLog = new JenkinsBuildInfoLog(listener);
            buildInfoLog.info("A 'jfrog' tool was not set. Using JFrog CLI from the system path.");
        }

        public Launcher.ProcStarter setupJFrogEnvironment(Run<?, ?> run, EnvVars env, Launcher launcher, TaskListener listener, FilePath workspace, String jfrogBinaryPath, boolean isWindows, boolean passwordStdinSupported) throws IOException, InterruptedException {
            JFrogCliConfigEncryption jfrogCliConfigEncryption = (JFrogCliConfigEncryption)run.getAction(JFrogCliConfigEncryption.class);
            if (jfrogCliConfigEncryption == null) {
                jfrogCliConfigEncryption = new JFrogCliConfigEncryption(env);
                run.addAction((Action)jfrogCliConfigEncryption);
            }
            FilePath jfrogHomeTempDir = Utils.createAndGetJfrogCliHomeTempDir(workspace, String.valueOf(run.getNumber()));
            CliEnvConfigurator.configureCliEnv(env, jfrogHomeTempDir.getRemote(), jfrogCliConfigEncryption);
            Launcher.ProcStarter jfLauncher = launcher.launch().envs((Map)env).pwd(workspace).stdout(listener);
            if (this.shouldConfig(jfrogHomeTempDir)) {
                this.logIfNoToolProvided(env, listener);
                this.configAllServers(jfLauncher, jfrogBinaryPath, isWindows, run.getParent(), passwordStdinSupported);
            }
            return jfLauncher;
        }

        public boolean isPasswordStdinEnabled(FilePath workspace, EnvVars environmentVariables, Launcher launcher, String jfrogBinaryPath) throws IOException, InterruptedException {
            TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
            JenkinsBuildInfoLog buildInfoLog = new JenkinsBuildInfoLog(listener);
            String readJFrogCliPwdStdinSupport = environmentVariables.get("JFROG_CLI_PASSWORD_STDIN_SUPPORT", "");
            Launcher.ProcStarter procStarter = launcher.launch().envs((Map)environmentVariables).pwd(workspace);
            Version currentCliVersion = JfStep.getJfrogCliVersion(procStarter, jfrogBinaryPath);
            boolean isMinimumCLIVersionPasswdSTDIN = currentCliVersion.isAtLeast(MIN_CLI_VERSION_PASSWORD_STDIN);
            if (StringUtils.isBlank((CharSequence)readJFrogCliPwdStdinSupport)) {
                boolean isPluginLauncher = launcher.getClass().getName().contains("org.jenkinsci.plugins");
                if (isPluginLauncher) {
                    buildInfoLog.debug("Password stdin is not supported,Launcher is a plugin launcher.");
                    return false;
                }
                buildInfoLog.debug("Password stdin is supported");
                return isMinimumCLIVersionPasswdSTDIN;
            }
            boolean isSupported = Boolean.parseBoolean(readJFrogCliPwdStdinSupport);
            if (isSupported && !isMinimumCLIVersionPasswdSTDIN) {
                buildInfoLog.error("Password input via stdin is not supported, JFrog CLI version is below the minimum required version.");
            }
            return isSupported && isMinimumCLIVersionPasswdSTDIN;
        }

        private boolean shouldConfig(FilePath jfrogHomeTempDir) throws IOException, InterruptedException {
            List filesList = jfrogHomeTempDir.list();
            for (FilePath file : filesList) {
                if (!file.getName().contains("jfrog-cli.conf")) continue;
                return false;
            }
            return true;
        }

        private void configAllServers(Launcher.ProcStarter launcher, String jfrogBinaryPath, boolean isWindows, Job<?, ?> job, boolean passwordStdinSupported) throws IOException, InterruptedException {
            List<JFrogPlatformInstance> jfrogInstances = JFrogPlatformBuilder.getJFrogPlatformInstances();
            if (jfrogInstances != null && !jfrogInstances.isEmpty()) {
                for (JFrogPlatformInstance jfrogPlatformInstance : jfrogInstances) {
                    int exitValue;
                    ArgumentListBuilder builder = new ArgumentListBuilder();
                    this.addConfigArguments(builder, jfrogPlatformInstance, job, jfrogBinaryPath, job, launcher, passwordStdinSupported);
                    if (isWindows) {
                        builder = builder.toWindowsCommand();
                    }
                    if ((exitValue = launcher.cmds(builder).join()) == 0) continue;
                    throw new RuntimeException("Running 'jf' command failed with exit code " + exitValue);
                }
            }
        }

        private void addConfigArguments(ArgumentListBuilder builder, JFrogPlatformInstance jfrogPlatformInstance, Job<?, ?> job1, String jfrogBinaryPath, Job<?, ?> job, Launcher.ProcStarter launcher, boolean passwordStdinSupported) {
            builder.add(jfrogBinaryPath).add("c").add("add").add(jfrogPlatformInstance.getId());
            JfStep.addCredentialsArguments(builder, jfrogPlatformInstance, job, launcher, passwordStdinSupported);
            JfStep.addUrlArguments(builder, jfrogPlatformInstance);
            builder.add("--interactive=false").add("--overwrite=true");
        }
    }
}

