/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ibmisteps.steps;

import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.IBMiMessage;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.Extension;
import java.io.IOException;
import org.jenkinsci.plugins.ibmisteps.Messages;
import org.jenkinsci.plugins.ibmisteps.model.CallResult;
import org.jenkinsci.plugins.ibmisteps.model.IBMi;
import org.jenkinsci.plugins.ibmisteps.model.LoggerWrapper;
import org.jenkinsci.plugins.ibmisteps.steps.abstracts.IBMiStep;
import org.jenkinsci.plugins.ibmisteps.steps.abstracts.IBMiStepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class IBMiCommandStep
extends IBMiStep<CallResult> {
    private static final long serialVersionUID = 6443392002952411163L;
    private final String command;
    private boolean failOnError = true;

    @DataBoundConstructor
    public IBMiCommandStep(String command) {
        this.command = command;
    }

    public String getCommand() {
        return this.command;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    @DataBoundSetter
    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    @Override
    protected CallResult runOnIBMi(StepContext context, LoggerWrapper logger, IBMi ibmi) throws AS400SecurityException, IOException, InterruptedException, ErrorCompletingRequestException {
        logger.log(Messages.IBMICommandStep_running(this.command));
        CallResult result = ibmi.executeCommand(this.command);
        IBMiMessage lastMessage = result.getLastMessage();
        if (result.isSuccessful()) {
            logger.log(Messages.IBMICommandStep_succeeded(this.command));
        } else {
            String error = lastMessage != null ? Messages.IBMICommandStep_failed_with_message(this.command, lastMessage.getID(), lastMessage.getText()) : Messages.IBMICommandStep_failed(this.command);
            if (!this.failOnError) {
                logger.error(error);
                logger.trace(result.getPrettyMessages());
            } else {
                logger.error(Messages.IBMICommandStep_failed(this.command) + "\n" + result.getPrettyMessages("\t"));
                throw new AbortException(error);
            }
        }
        return result;
    }

    @Extension
    public static class DescriptorImpl
    extends IBMiStepDescriptor {
        public String getFunctionName() {
            return "ibmiCommand";
        }

        @NonNull
        public String getDisplayName() {
            return Messages.IBMICommandStep_description();
        }
    }
}

