/*
 * Decompiled with CFR 0.152.
 */
package cloud.dnation.jenkins.plugins.hetzner.shutdown;

import cloud.dnation.jenkins.plugins.hetzner.Helper;
import cloud.dnation.jenkins.plugins.hetzner.HetznerServerAgent;
import cloud.dnation.jenkins.plugins.hetzner.Messages;
import cloud.dnation.jenkins.plugins.hetzner.shutdown.AbstractShutdownPolicy;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.slaves.AbstractCloudComputer;
import hudson.slaves.RetentionStrategy;
import java.io.IOException;
import java.time.LocalDateTime;
import net.jcip.annotations.GuardedBy;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeforeHourWrapsPolicy
extends AbstractShutdownPolicy {
    private static final Logger log = LoggerFactory.getLogger(BeforeHourWrapsPolicy.class);
    private static final RetentionStrategy<AbstractCloudComputer> STRATEGY_SINGLETON = new RetentionStrategyImpl();

    @DataBoundConstructor
    public BeforeHourWrapsPolicy() {
        super(STRATEGY_SINGLETON);
    }

    @Override
    public RetentionStrategy<AbstractCloudComputer> getRetentionStrategy() {
        return STRATEGY_SINGLETON;
    }

    private static class RetentionStrategyImpl
    extends RetentionStrategy<AbstractCloudComputer> {
        private RetentionStrategyImpl() {
        }

        public void start(@NonNull AbstractCloudComputer c) {
            c.connect(false);
        }

        @GuardedBy(value="hudson.model.Queue.lock")
        public long check(@NonNull AbstractCloudComputer c) {
            HetznerServerAgent agent = (HetznerServerAgent)c.getNode();
            if (c.isIdle() && agent != null && agent.getServerInstance() != null && Helper.canShutdownServer(agent.getServerInstance().getServerDetail().getCreated(), LocalDateTime.now())) {
                log.info("Disconnecting {}", (Object)c.getName());
                try {
                    agent.terminate();
                }
                catch (IOException | InterruptedException e) {
                    log.warn("Failed to terminate {}", (Object)c.getName(), (Object)e);
                }
            }
            return 1L;
        }
    }

    @Extension
    @Symbol(value={"hour-wrap"})
    public static final class DescriptorImpl
    extends Descriptor<AbstractShutdownPolicy> {
        @NonNull
        public String getDisplayName() {
            return Messages.policy_shutdown_beforeHourWrap();
        }
    }
}

