/*
 * Decompiled with CFR 0.152.
 */
package cloud.dnation.jenkins.plugins.hetzner.primaryip;

import cloud.dnation.hetznerclient.CreateServerRequest;
import cloud.dnation.hetznerclient.GetAllPrimaryIpsResponse;
import cloud.dnation.hetznerclient.HetznerApi;
import cloud.dnation.hetznerclient.PrimaryIpDetail;
import cloud.dnation.hetznerclient.PublicNetRequest;
import cloud.dnation.jenkins.plugins.hetzner.primaryip.AbstractPrimaryIpStrategy;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractByLabelSelector
extends AbstractPrimaryIpStrategy {
    private static final Logger log = LoggerFactory.getLogger(AbstractByLabelSelector.class);
    private final String selector;

    public AbstractByLabelSelector(boolean failIfError, String selector) {
        super(failIfError);
        this.selector = selector;
    }

    @Override
    public void applyInternal(HetznerApi api, CreateServerRequest server) throws IOException {
        PrimaryIpDetail pip = ((GetAllPrimaryIpsResponse)api.getAllPrimaryIps(this.selector).execute().body()).getPrimaryIps().stream().filter(ip -> AbstractByLabelSelector.isIpUsable(ip, server)).findFirst().get();
        PublicNetRequest net = new PublicNetRequest();
        net.setIpv4(pip.getId());
        net.setEnableIpv6(Boolean.valueOf(false));
        net.setEnableIpv4(Boolean.valueOf(true));
        server.setPublicNet(net);
    }

    @VisibleForTesting
    static boolean isIpUsable(PrimaryIpDetail ip, CreateServerRequest server) {
        if (ip.getAssigneeId() != null) {
            return false;
        }
        if (!Strings.isNullOrEmpty((String)server.getLocation()) && server.getLocation().equals(ip.getDatacenter().getLocation().getName())) {
            return true;
        }
        if (!Strings.isNullOrEmpty((String)server.getDatacenter())) {
            return server.getDatacenter().equals(ip.getDatacenter().getName());
        }
        return false;
    }

    public String getSelector() {
        return this.selector;
    }
}

