/*
 * Decompiled with CFR 0.152.
 */
package cloud.dnation.jenkins.plugins.hetzner.launcher;

import cloud.dnation.hetznerclient.ServerDetail;
import cloud.dnation.jenkins.plugins.hetzner.Messages;
import cloud.dnation.jenkins.plugins.hetzner.launcher.AbstractConnectionMethod;
import com.google.common.base.Strings;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Descriptor;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class PublicV6AddressOnly
extends AbstractConnectionMethod {
    @Override
    public String getAddress(ServerDetail server) {
        if (server.getPublicNet().getIpv6() == null || Strings.isNullOrEmpty((String)server.getPublicNet().getIpv6().getIp())) {
            throw new IllegalArgumentException("Connection method requires IPv6 address");
        }
        return server.getPublicNet().getIpv6().getIp().replaceFirst("::/64$", "::1");
    }

    @DataBoundConstructor
    public PublicV6AddressOnly() {
    }

    @Extension
    @Symbol(value={"publicV6"})
    public static final class DescriptorImpl
    extends Descriptor<AbstractConnectionMethod> {
        @NonNull
        public String getDisplayName() {
            return Messages.connection_method_publicV6();
        }
    }
}

