/*
 * Decompiled with CFR 0.152.
 */
package cloud.dnation.jenkins.plugins.hetzner.launcher;

import cloud.dnation.hetznerclient.ServerDetail;
import cloud.dnation.jenkins.plugins.hetzner.Helper;
import cloud.dnation.jenkins.plugins.hetzner.HetznerConstants;
import cloud.dnation.jenkins.plugins.hetzner.HetznerServerAgent;
import cloud.dnation.jenkins.plugins.hetzner.HetznerServerComputer;
import cloud.dnation.jenkins.plugins.hetzner.launcher.AbstractHetznerSshConnector;
import com.cloudbees.jenkins.plugins.sshcredentials.SSHAuthenticator;
import com.cloudbees.jenkins.plugins.sshcredentials.impl.BasicSSHUserPrivateKey;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Uninterruptibles;
import com.trilead.ssh2.Connection;
import com.trilead.ssh2.SCPClient;
import com.trilead.ssh2.ServerHostKeyVerifier;
import com.trilead.ssh2.Session;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.Util;
import hudson.model.TaskListener;
import hudson.remoting.Channel;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.SlaveComputer;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import jenkins.model.Jenkins;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HetznerServerComputerLauncher
extends ComputerLauncher {
    private static final Logger log = LoggerFactory.getLogger(HetznerServerComputerLauncher.class);
    private static final String AGENT_SCRIPT = ".agent.start.sh";
    private final AtomicBoolean terminated = new AtomicBoolean(false);
    private final AbstractHetznerSshConnector connector;

    private static String getRemoteFs(HetznerServerAgent agent) {
        String res = Helper.getStringOrDefault(agent.getRemoteFS(), "/home/jenkins");
        if (res.endsWith("/")) {
            return res.substring(0, res.length() - 1);
        }
        return res;
    }

    private void copyAgent(Connection connection, HetznerServerComputer computer, Helper.LogAdapter logger, String remoteFs) throws IOException {
        byte[] agentBlob = Jenkins.get().getJnlpJars("remoting.jar").readFully();
        String remoteAgentPath = remoteFs + "/remoting.jar";
        byte[] launchScriptContent = ("#!/bin/sh\n" + this.getAgentCommand(computer, remoteFs) + "\n").getBytes(StandardCharsets.UTF_8);
        String launchScriptPath = remoteFs + "/.agent.start.sh";
        SCPClient scp = connection.createSCPClient();
        logger.info("Copying agent JAR - " + agentBlob.length + " bytes into " + remoteAgentPath);
        scp.put(agentBlob, "remoting.jar", remoteFs, "0644");
        logger.info("Copying agent script - " + launchScriptContent.length + " bytes into " + launchScriptPath);
        scp.put(launchScriptContent, AGENT_SCRIPT, remoteFs, "0755");
    }

    @SuppressFBWarnings(value={"NP_NULL_PARAM_DEREF"})
    public void launch(SlaveComputer computer, TaskListener listener) throws IOException, InterruptedException {
        if (!(computer instanceof HetznerServerComputer)) {
            throw new AbortException("Incompatible computer : " + String.valueOf(computer));
        }
        HetznerServerComputer hcomputer = (HetznerServerComputer)computer;
        if (this.connector.getConnectionMethod() == null) {
            this.connector.setConnectionMethod(HetznerConstants.DEFAULT_CONNECTION_METHOD);
        }
        if (this.connector.getSshPort() == 0) {
            this.connector.setSshPort(22);
        }
        Helper.LogAdapter logger = new Helper.LogAdapter(listener.getLogger(), log);
        HetznerServerAgent node = (HetznerServerAgent)hcomputer.getNode();
        Preconditions.checkState((node != null && node.getServerInstance() != null ? 1 : 0) != 0, (String)"Missing node or server instance data in computer %s", (Object)computer.getName());
        String remoteFs = HetznerServerComputerLauncher.getRemoteFs(node);
        Connection connection = this.setupConnection(node, logger, listener);
        this.copyAgent(connection, hcomputer, logger, remoteFs);
        this.launchAgent(connection, hcomputer, logger, listener, remoteFs);
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="NULLnes of node is checked in launch method")
    private String getAgentCommand(HetznerServerComputer computer, String remoteFs) {
        String jvmOpts = Util.fixNull((String)((HetznerServerAgent)computer.getNode()).getTemplate().getJvmOpts());
        return "java " + jvmOpts + " -jar " + remoteFs + "/remoting.jar -workDir " + remoteFs;
    }

    private void launchAgent(final Connection connection, HetznerServerComputer computer, Helper.LogAdapter logger, TaskListener listener, String remoteFs) throws IOException, InterruptedException {
        String launchCmd;
        HetznerServerAgent node = (HetznerServerAgent)computer.getNode();
        final Session session = connection.openSession();
        String scriptCmd = "/bin/sh " + remoteFs + "/.agent.start.sh";
        String username = this.connector.getUsernameOverride();
        if (username != null) {
            String credentialsId = node.getTemplate().getConnector().getSshCredentialsId();
            BasicSSHUserPrivateKey privateKey = Helper.assertSshKey(credentialsId);
            launchCmd = "sudo -n -u " + privateKey.getUsername() + " " + scriptCmd;
        } else {
            launchCmd = scriptCmd;
        }
        logger.info("Launching agent using '" + launchCmd + "'");
        session.execCommand(launchCmd);
        computer.setChannel(session.getStdout(), session.getStdin(), listener, new Channel.Listener(){

            public void onClosed(Channel channel, IOException cause) {
                session.close();
                connection.close();
            }
        });
    }

    private Connection setupConnection(HetznerServerAgent node, Helper.LogAdapter logger, TaskListener taskListener) throws InterruptedException, AbortException {
        int retries = 10;
        while (!this.terminated.get() && retries-- > 0) {
            ServerDetail serverDetail = node.getServerInstance().getServerDetail();
            String ipv4 = this.connector.getConnectionMethod().getAddress(serverDetail);
            int port = this.connector.getSshPort();
            Connection conn = new Connection(ipv4, port);
            try {
                conn.connect((ServerHostKeyVerifier)AllowAnyServerHostKeyVerifier.INSTANCE, 30000, 10000);
                logger.info("Connected to " + node.getNodeName() + " via " + ipv4 + ":" + port);
                String credentialsId = node.getTemplate().getConnector().getSshCredentialsId();
                BasicSSHUserPrivateKey privateKey = Helper.assertSshKey(credentialsId);
                String username = (String)Util.fixNull((Object)node.getTemplate().getConnector().getUsernameOverride(), (Object)privateKey.getUsername());
                logger.info("Authenticating using username '" + username + "'");
                SSHAuthenticator authenticator = SSHAuthenticator.newInstance((Object)conn, (StandardUsernameCredentials)privateKey, (String)username);
                if (authenticator.authenticate(taskListener) && conn.isAuthenticationComplete()) {
                    logger.info("Authentication succeeded");
                    return conn;
                }
                throw new AbortException("Authentication failed");
            }
            catch (IOException e) {
                logger.error("Connection to " + ipv4 + " failed. Will wait 10 seconds before retry", e);
                Uninterruptibles.sleepUninterruptibly((long)10L, (TimeUnit)TimeUnit.SECONDS);
            }
        }
        throw new AbortException("Failed to launch agent");
    }

    public void signalTermination() {
        this.terminated.set(true);
    }

    public HetznerServerComputerLauncher(AbstractHetznerSshConnector connector) {
        this.connector = connector;
    }

    private static class AllowAnyServerHostKeyVerifier
    implements ServerHostKeyVerifier {
        static final AllowAnyServerHostKeyVerifier INSTANCE = new AllowAnyServerHostKeyVerifier();

        private AllowAnyServerHostKeyVerifier() {
        }

        public boolean verifyServerHostKey(String hostname, int port, String serverHostKeyAlgorithm, byte[] serverHostKey) throws Exception {
            return true;
        }
    }
}

