/*
 * Decompiled with CFR 0.152.
 */
package cloud.dnation.jenkins.plugins.hetzner.launcher;

import cloud.dnation.jenkins.plugins.hetzner.ConfigurationValidator;
import cloud.dnation.jenkins.plugins.hetzner.launcher.AbstractConnectionMethod;
import cloud.dnation.jenkins.plugins.hetzner.launcher.DefaultConnectionMethod;
import cloud.dnation.jenkins.plugins.hetzner.launcher.HetznerServerComputerLauncher;
import com.cloudbees.jenkins.plugins.sshcredentials.impl.BasicSSHUserPrivateKey;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.util.Collections;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHetznerSshConnector
extends AbstractDescribableImpl<AbstractHetznerSshConnector> {
    private static final Logger log = LoggerFactory.getLogger(AbstractHetznerSshConnector.class);
    @Nullable
    protected String usernameOverride;
    protected String sshCredentialsId;
    protected int sshPort = 22;
    protected AbstractConnectionMethod connectionMethod = DefaultConnectionMethod.SINGLETON;

    public HetznerServerComputerLauncher createLauncher() {
        return new HetznerServerComputerLauncher(this);
    }

    protected Object readResolve() {
        if (this.sshPort == 0) {
            this.sshPort = 22;
        }
        return this;
    }

    @Nullable
    public String getUsernameOverride() {
        return this.usernameOverride;
    }

    @DataBoundSetter
    public void setUsernameOverride(@Nullable String usernameOverride) {
        this.usernameOverride = usernameOverride;
    }

    public String getSshCredentialsId() {
        return this.sshCredentialsId;
    }

    @DataBoundSetter
    public void setSshCredentialsId(String sshCredentialsId) {
        this.sshCredentialsId = sshCredentialsId;
    }

    public int getSshPort() {
        return this.sshPort;
    }

    @DataBoundSetter
    public void setSshPort(int sshPort) {
        this.sshPort = sshPort;
    }

    public AbstractConnectionMethod getConnectionMethod() {
        return this.connectionMethod;
    }

    @DataBoundSetter
    public void setConnectionMethod(AbstractConnectionMethod connectionMethod) {
        this.connectionMethod = connectionMethod;
    }

    public static abstract class DescriptorImpl
    extends Descriptor<AbstractHetznerSshConnector> {
        @Restricted(value={NoExternalUse.class})
        @RequirePOST
        public FormValidation doCheckSshCredentialsId(@QueryParameter String sshCredentialsId) {
            return ConfigurationValidator.doCheckNonEmpty(sshCredentialsId, "SSH credentials");
        }

        @Restricted(value={NoExternalUse.class})
        @RequirePOST
        public ListBoxModel doFillSshCredentialsIdItems(@AncestorInPath Item owner) {
            StandardListBoxModel result = new StandardListBoxModel();
            if (owner == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !owner.hasPermission(Item.EXTENDED_READ) && !owner.hasPermission(CredentialsProvider.USE_ITEM)) {
                return result;
            }
            return new StandardListBoxModel().includeEmptyValue().includeMatchingAs(ACL.SYSTEM2, owner, BasicSSHUserPrivateKey.class, Collections.emptyList(), CredentialsMatchers.always());
        }
    }
}

