/*
 * Decompiled with CFR 0.152.
 */
package cloud.dnation.jenkins.plugins.hetzner;

import cloud.dnation.hetznerclient.ServerDetail;
import cloud.dnation.jenkins.plugins.hetzner.Helper;
import cloud.dnation.jenkins.plugins.hetzner.HetznerCloud;
import hudson.Extension;
import hudson.model.PeriodicWork;
import hudson.model.Slave;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
@Symbol(value={"OrphanedNodesCleaner"})
public class OrphanedNodesCleaner
extends PeriodicWork {
    private static final Logger log = LoggerFactory.getLogger(OrphanedNodesCleaner.class);

    public long getRecurrencePeriod() {
        return 3600000L;
    }

    private static Set<HetznerCloud> getHetznerClouds() {
        return Jenkins.get().clouds.stream().filter(HetznerCloud.class::isInstance).map(HetznerCloud.class::cast).collect(Collectors.toSet());
    }

    protected void doRun() {
        OrphanedNodesCleaner.doCleanup();
    }

    static void doCleanup() {
        OrphanedNodesCleaner.getHetznerClouds().forEach(OrphanedNodesCleaner::cleanCloud);
    }

    private static void cleanCloud(HetznerCloud cloud) {
        try {
            List<ServerDetail> allInstances = cloud.getResourceManager().fetchAllServers(cloud.name);
            List<String> jenkinsNodes = Helper.getHetznerAgents().stream().map(Slave::getNodeName).toList();
            allInstances.stream().filter(server -> !jenkinsNodes.contains(server.getName())).forEach(serverDetail -> OrphanedNodesCleaner.terminateServer(serverDetail, cloud));
        }
        catch (IOException e) {
            log.warn("Error while fetching all servers", (Throwable)e);
        }
    }

    private static void terminateServer(ServerDetail serverDetail, HetznerCloud cloud) {
        log.info("Terminating orphaned server {}", (Object)serverDetail.getName());
        cloud.getResourceManager().destroyServer(serverDetail);
    }
}

